/****************************************************************************
** chatdlg.h - a single window chat dialog
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef CHATDLG_H
#define CHATDLG_H

#include<qwidget.h>
#include<qlineedit.h>
#include<qlabel.h>
#include<qtoolbutton.h>
#include<qtimer.h>
#include"jabcommon.h"
#include"msgmle.h"
#include"message.h"
#include"userlist.h"
#include"uniquewindow.h"

class ChatDlg : public QWidget, public UniqueWindow
{
	Q_OBJECT
public:
	ChatDlg(UserListItem *item, const QString &, int _localStatus, QWidget *parent=0);
	~ChatDlg();

	QString & jid() { return v_jid; }
	static ChatDlg *find(const QString &);
	static QSize defaultSize();

	MsgMle *t;
        ChatMle *mle;

	// reimplemented
protected:
	void keyPressEvent(QKeyEvent *);
	void closeEvent(QCloseEvent *);
	void resizeEvent(QResizeEvent *);
	void showEvent(QShowEvent *);
	void windowActivationChange(bool);

signals:
	void aSend(const Message &);
	void aHistory(const QString &jid);
	void aAuth(const QString &jid);
	void aAdd(const QString &jid);
	void aInfo(const QString &jid);
	void aOpenURL(const QString &url);

public slots:
        void localUpdate(const JabRosterEntry &);
	void updateContact(UserListItem *);
	void incomingMessage(const Message &);
	void optionsUpdate();

private slots:
	void doSend();
	void doHistory();
	void doAuth();
	void doAdd();
	void doInfo();
	void doClear();
	void doClearButton();

	void deferredScroll();
	void setKeepOpenFalse();
	void flashAnimate();

private:
	QString v_jid, v_nick;
	int v_status;
	int localStatus;
	QString whoami, dispNick;
	int pending;
	bool keepOpen;

	QWidget *lo_single;
	QLineEdit *le_nick, *le_jid;
	QLabel *lb_statusIcon;
	QToolButton *tb_send, *tb_history, *tb_info;

	void appendMessage(const Message &);
	void appendSysMsg(const QString &);
	void updateCaption();

	void setLooks();
	QTimer *selfDestruct;
	void setSelfDestruct(int);

	void doFlash(bool);
	QTimer *flashTimer;
	int flashCount;
};

#endif

