/****************************************************************************
** anim.h - handles animations
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef ANIM_H
#define ANIM_H

#include<qpixmap.h>
#include<qimage.h>
#include<qptrvector.h>

class Anim
{
public:
	Anim(const QPixmap &);
	~Anim();

	QPixmap & frame(int);
	QPixmap & base();
	QImage & qim_frame(int);
	QImage & qim_base();
	bool isAnim() { return v_isAnim; }
	int numFrames() { return v_numFrames; }

private:
	QPtrVector<QPixmap> seq;
	QPtrVector<QImage> qim_seq;
	int v_numFrames;
	bool v_isAnim;
};

#endif
