/****************************************************************************
** adduserdlg.h - a dialog for adding a contact
** Copyright (C) 2001, 2002  Justin Karneges
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License
** as published by the Free Software Foundation; either version 2
** of the License, or (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
**
****************************************************************************/

#ifndef ADDUSERDLG_H
#define ADDUSERDLG_H

#include<qdialog.h>
#include<qlineedit.h>
#include<qcombobox.h>
#include<qstringlist.h>
#include"jabcommon.h"
#include"busywidget.h"
#include"ui_adduser.h"


class AddUserDlg : public AddUserUI
{
	Q_OBJECT
public:
	AddUserDlg(const QStringList &services, const QStringList &names, const QStringList &groups, int localStatus, QWidget *parent=0, const char *name=0);
	~AddUserDlg();

	static AddUserDlg *find();

	struct Info
	{
		QString jid;
		QString nick;
		QString group;
	};

signals:
	void add(const AddUserDlg::Info &);
	void signalGetGateway(const QString &service, QString *id);
	void signalSetGateway(const QString &service, const QString &prompt, QString *id);
	void signalCancelTransaction(const QString &);

public slots:
	void slotGetGatewayResponse(const QString &id, bool ok, const QString &desc);
	void slotSetGatewayResponse(const QString &id, bool ok, const QString &jid);

	void localUpdate(const JabRosterEntry &);

private:
	BusyWidget *busy;
	int localStatus;
	Info info;
	QStringList services;
	QString id;
	bool active;

	void errorGateway();

private slots:
	void ok();
	void serviceActivated(int);
	void getTransID();
};

#endif
