/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: xml_report.c,v 1.6 2004/01/09 20:29:28 type2 Exp $ */

/*
 *******************************************************************************
 *
 *                            PROSPECT PROJECT
 *                        XML Report Output Module
 *
 *******************************************************************************
 */

#ifndef __LINT__
static const char gRCSid[] = "@(#) $Id: xml_report.c,v 1.6 2004/01/09 20:29:28 type2 Exp $";
#endif

/*
 * System Header Files
 */

/*
 * Prospect Header Files
 */
#include "prospect.h"
#include "rec_proc.h"
#include "app_perf-n.h"

/*
 * void xml_generate_dtd(void)
 *
 * Generates the DTD definition on output.
 */
void 
xml_generate_dtd(void)
{
    int ii=0;

    /* *dtd_file[] is from app_perf-n.h above */
    while (dtd_file[ii] != NULL)
    {
        pscr(dtd_file[ii]);
        ii++;
    }

} /* xml_generate_dtd() */

/*
 * void xml_print_done(void)
 *
 * Landing place for XML report generation.
 */
void
xml_print_done(void)
{
    mINFORM("In xml_print_done().");

    pscr("*****> My appologies, but XML output is not done yet.\n");

    /* we're done */
    prospect_exit(0);

} /* xml_print_done() */


