/***************************************************************************
                          gui_sourcer.h  -  description
                             -------------------
    begin                : Wed May 2 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_SOURCER_H
#define GUI_SOURCER_H

#include "prokyon.h"

#include "lvi_cddrive.h"
#include "lvi_smbshare.h"
#include "lvi_nfsexport.h"

#include <qwidget.h>
#include <qlistview.h>
#include <qmap.h>

class GUI_Sourcer : public QListView  {
    Q_OBJECT
public:
    GUI_Sourcer(QWidget *parent=0, const char *name=0);

    void notifyAddReadWriteLock() {
        rwLock++;
    }
    void notifyRemoveReadWriteLock() {
        rwLock--;
    }

    void notifyDirHasChanged(QString dir);

    void notifyStartedHarddiskSynchronizing();
    void notifyStoppedHarddiskSynchronizing();
    void notifyStartedCDROMSynchronizing(LVI_CDDrive *drive);
    void notifyStoppedCDROMSynchronizing(LVI_CDDrive *drive);
    void notifyStartedSMBSynchronizing(LVI_SMBShare *share);
    void notifyStoppedSMBSynchronizing(LVI_SMBShare *share);
    void notifyStartedNFSSynchronizing(LVI_NFSExport *Export);
    void notifyStoppedNFSSynchronizing(LVI_NFSExport *Export);

    void notifyCDROMInserted(LVI_CDDrive *drive);
    void notifySMBMounted(LVI_SMBShare *share);
    void notifyNFSMounted(LVI_NFSExport *Export);
    void notifyNewMediumBasis(QList<MEDIUM> *list);
    void notifyNewMedium(MEDIUM *medium);
    void notifyMediumRemoved(int id);
    void notifyMediumRenamed(MEDIUM *medium);

    bool existsLabel(QString);
    LVI_SMBShare *getSMBByID(int);
    LVI_NFSExport *getNFSByID(int);

    void init();

    ~GUI_Sourcer();

public slots:
    void slot_setConnectionState(bool state);

protected:
    void resizeEvent(QResizeEvent*);

private:
    bool isPathMounted(QString path);
    bool isPathAutoMounted(QString path);

    LVI_CDDrive *currCDROM;
    LVI_SMBShare *currSMB;
    LVI_NFSExport *currNFS;

    QMap<int, LVI_CDDrive*> mapCDROM;
    QMap<int, LVI_SMBShare*> mapSMB;
    QMap<int, LVI_NFSExport*> mapNFS;

    QMap<unsigned, int> mapChecksum;
    QMap<int, QString>  mapLabel;

    QMap<QString, int>  mapSMBDevice;
    QMap<QString, int>  mapNFSDevice;

    QListViewItem *lviHDD;

    bool isConnected;
    bool doSynchro;

    int rwLock;

    //  KDirWatch *watcher;

private slots:
    void slot_contextMenu(QListViewItem* item, const QPoint &point, int);
    void slot_menuMountCDROM();
    void slot_menuUnmountCDROM();
    void slot_menuEjectCDROM();
    void slot_menuMountSMB();
    void slot_menuUnmountSMB();
    void slot_menuMountNFS();
    void slot_menuUnmountNFS();
    void slot_menuAppendCDROM();
    void slot_menuAppendSMB();
    void slot_menuAppendNFS();

    void slot_menuSynchronize1();
    void slot_menuSynchronize2();
    void slot_menuSynchronize3();
    void slot_menuSynchronize4();
    void slot_menuSynchronize5();
    void slot_menuSynchronize6();
    void slot_menuSynchronize7();
    void slot_menuSynchronize11();
    void slot_menuSynchronize12();
    void slot_menuSynchronize13();
    void slot_menuSynchronize14();
    void slot_menuSynchronize15();
    void slot_menuSynchronize16();
    void slot_menuSynchronize17();
    void slot_menuSynchronize21();
    void slot_menuSynchronize31();
    void slot_menuSynchronize32();
    void slot_menuSynchronize33();
    void slot_menuSynchronize34();
    void slot_menuSynchronize35();
    void slot_menuSynchronize36();
    void slot_menuSynchronize37();
    void slot_menuHelp();
};

#endif
