/***************************************************************************
                          database.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DATABASE_H
#define DATABASE_H

#include "prokyon.h"

#include <qthread.h>
#include <qstring.h>
#include <qptrlist.h>
#include <qmap.h>

class DataBase : public QObject {
 public:
  DataBase() {}
  
  void lock() { mutex.lock(); }
  void unlock() { mutex.unlock(); }
  
  virtual void establishConnection(QString host, QString db, QString user, QString pass) = 0;
  
  virtual QString createNewDatabase(QString host, QString db, QString user, QString pass, QString su, QString su_pass, QString clienthost) = 0;

  virtual QList<ARTISTALBUM> *getAlbumBasis() = 0;
  virtual QList<ARTISTALBUM> *getFavouritesBasis() = 0;
  virtual QList<ARTISTALBUM> *getArtistAlbumBasis() = 0;
  virtual QList<MEDIUM> *getMediumBasis() = 0;
  virtual QList<PLAYLIST> *getPlaylistBasis() = 0;
  virtual QList<PLAYLIST_TRACK> *getPlaylistTracksBasis(int playlistID) = 0;

#ifdef HAVE_MEXTRAS
  virtual EXTRADATA_GUI *getExtraData(TRACK *) = 0;
  virtual EXTRA_STATUS checkMextras(TRACK *track) = 0;
  virtual void updateMextras(EXTRADATA *data, TRACK *track) = 0;
  virtual int addByteArrayMextras(QByteArray& pix) = 0;
  virtual int addStringMextras(QString& st) = 0;
  virtual void alterImageArtistsMextras(int image_id, int artists_id) = 0;
  virtual void alterYearsActiveArtistsMextras(QString& years_active, int artists_id) = 0;
  virtual void alterBiographyArtistsMextras(int biography_id, int artists_id) = 0;
  virtual void alterLyricsTracksMextras(int lyrics_id, int tracks_id) = 0;
  virtual void alterCoverTracksMextras(int cover_id, int tracks_id, const QString, const QString) = 0;
  virtual void alterAlbumReviewTracksMextras(int album_review_id, int tracks_id) = 0;
  virtual void alterAlbumTracksTracksMextras(int album_tracks_id, int album_id) = 0;
  virtual void deleteMextras(int ID) = 0;
  virtual void zapExtraData() =0;
  virtual void zapExtraData(TRACK*) =0;

  virtual const QByteArray getByteArrayMextras(int ID) = 0;
  virtual const QString    getStringMextras(int ID) = 0;
#endif /* HAVE_MEXTRAS */

  virtual void generatePlaylist(int playlistID, int numberTracks, int minTrackLength, int maxTrackLength, bool onlyFavouriteArtists, bool onlyHarddisk, int minRating) = 0;

  virtual QMap<int, QMap<int, DELTAINFO*> > *getArtistDelta() = 0;
  virtual QMap<int, QMap<int, int> > *getLocalDeltaBasis() = 0;
  virtual QMap<int, int> getLocalDelta(int id) = 0;
  virtual QMap<int, QMap<QString, int> > *getLocalAlbumDeltaBasis() = 0;
  virtual QMap<QString, int> getLocalAlbumDelta(int id) = 0;
  virtual QMap<QString,QString> getCustomQueries() = 0;
  
  virtual void storeCustomQuery(QString, QString) = 0;
  virtual void removeCustomQuery(QString) = 0;
  
  virtual int appendTracks(QList<TRACK> *tracklist, int mediumtype, QString mediumlabel, QString mediumpath, unsigned mediumchecksum, bool createNewMedium, int mediumID) = 0;
  virtual void updateTracks(QList<TRACK> *tracklist) = 0;
  virtual void deleteTracks(QList<TRACK> *tracklist) = 0;

  virtual int getPlaylistIdByName(QString listname) = 0;
  virtual int appendPlaylist(QString listname) = 0;
  virtual void renamePlaylist(int id, QString newname) = 0;
  virtual void deletePlaylist(int id) = 0;

  virtual int appendPlaylistTracks(QList<TRACK> *tracklist, int playlistID, int *position) = 0;
  virtual void deletePlaylistTracks(QList<TRACK> *tracklist) = 0;
  virtual void deletePlaylistTracks(QList<PLAYLIST_TRACK> *playlist_tracklist) = 0;
  virtual void updatePlaylistTrack(int playlistID, int trackID, int new_pos) = 0;
  
  virtual void deleteMedium(int id) = 0;
  virtual void renameMedium(MEDIUM *medium) = 0;

  virtual void modifyFavouriteArtist(int, bool) = 0;

  virtual int getCountFromTable(QString) = 0;
  virtual int getCountColumnDistinctFromTable(QString, QString) = 0;

  virtual QList<TRACK> *getTracksByMedium(int id) = 0;
  
  virtual QList<TRACK> *queryTracksByMedium(int id) = 0;
  virtual QList<TRACK> *queryTracksByArtist(int id) = 0;
  virtual QList<TRACK> *queryTracksByArtistAlbum(QString artist, QString album) = 0;
  virtual QList<TRACK> *queryTracksByAlbum(QString sampler, QString album) = 0;
  virtual QList<TRACK> *queryTracksByPlaylist(int id) = 0;
  virtual QList<TRACK> *queryTracksByPhrase(QString phrase, bool byFilename, bool byArtist, bool byTitle, bool byAlbum, bool byComment, bool byNotes) = 0;
  virtual QList<TRACK> *queryTracksByWhere(QString phrase) = 0;
  
  virtual QList<TRACK> *getLastQuery() = 0;
  
  virtual QPixmap* getAlbumThumbnail(const QString, const QString) = 0;
  
  virtual void disconnect() = 0;
  
  int getError()
  { 
    int lastError = error;
    error = 0;
    return lastError;
  }	
  
  virtual ~DataBase() {}
  
 protected:
  int error;
  
 private:
  QMutex mutex;
};

#endif
