/*
    ProjectTypeLoader.h

    Interface declaration of the ProjectTypeLoader class for the
    ProjectManager application.

    Copyright (C) 2005  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class NSDictionary, NSArray, NSString;

@class ProjectDocument;
@protocol ProjectType;

@interface ProjectTypeLoader : NSObject
{
  /* A dictionary where keys are project type IDs and values
   * are classes which handle them. */
  NSDictionary * projectTypes;
}

/// Returns a shared instance of a ProjectTypeLoader.
+ shared;

/**
 * Returns the a dictionary where keys are project types and values are
 * classes which implement the respective project type.
 */
- (NSDictionary *) projectTypes;

/**
 * Initializes a project type of type `projectTypeID' for a project
 * named `projectName', located at `aPath' and with `infoDict' where the
 * project type has it's saved private data.
 */
- (id <ProjectType>) projectTypeForTypeID: (NSString *) projectTypeID
                                  project: (ProjectDocument *) project
                           infoDictionary: (NSDictionary *) infoDict
                           projectModules: (NSArray *) projectModules;

@end
