/*
    GNUstepAppLauncherDelegate.h

    Declaration of the GNUstepAppLauncherDelegate protocol for the
    ProjectManager app.

    Copyright (C) 2005, 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@class GNUstepAppLauncher;

@protocol GNUstepAppLauncherDelegate

/**
 * The delegate should provide a list of target-names which the launcher
 * will display in it's target button.
 *
 * @param sender The sending launcher object.
 *
 * @return An array of names which the user may select as launch targets.
 */
- (NSArray *) launchTargetsForAppLauncher: (id) sender;

/**
 * Asks the delegate whether the sender should delay a launch. Delaying
 * a launch may be desirable in case the project needs to be built first.
 *
 * @param sender The sending launcher object.
 * @param targetType The type of the target which would be launched.
 *
 * @return NO if the project should be launched immediatelly. In case
 *      the delegate wants to delay the launch, it should return YES and
 *      then send a -proceedWithLaunch: message to the sender.
 */
- (BOOL)         appLauncher: (id) sender
 shouldDelayLaunchWithTarget: (NSString *) target;

/**
 * This message is sent to the delegate in case it requested the
 * sender to delay launching and the user hit the `Stop' button in
 * the mean time. The delegate must stop any launch preparations.
 *
 * @param sender The sending launcher object.
 */
- (void) stopDelayedLaunchForAppLauncher: (id) sender;

/**
 * The delegate should provide a path to the binary of the project.
 *
 * @param sender The sending launcher object.
 * @param targetType The type of the project binary to which to provide
 *      the path.
 *
 * @return A path to the binary of the project which can be executed.
 */
- (NSString *) appLauncher: (id) sender
 pathToProjectBinaryOfType: (NSString *) target;

@end
