/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: titlenode.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:45  slash
 * Initial release.
 *
 */

#ifndef TITLENODE_H
#define TITLENODE_H

#include "environmentnode.h"

//---------------------------------------------------------------------------
/**
 * This class represents a title-node.
 */
class TitleNode : public EnvironmentNode {
  public:
    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the title-node.
     *
     * @param node The XML-node, which represents the title-node.
     */
    TitleNode(xmlNodePtr node);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~TitleNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be HTML.
     * An integer-parameter has to be given because of the derivation,
     * but it won't be used in this class.
     *
     * @param parameter A dummy-parameter.
     */
    void writeHTML(int parameter = 0) const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;

    //-----------------------------------------------------------------------
    /**
     * This method signals, if the HTML-output of the title-environment
     * should be stepped.
     *
     * @return Always 0.
     */
    int isHTMLStepped() const;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of steps of the HTML-output.
     *
     * @return Always 0.
     */
    unsigned int getNumberOfHTMLSteps() const;
};

#endif //TITLENODE_H
