/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: titlenode.cc,v $
 * Revision 1.2  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.1.1.1  2001/01/30 18:36:23  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "headingnode.h"
#include "authornode.h"
#include "datenode.h"
#include "titlenode.h"


//---------------------------------------------------------------------------
TitleNode::TitleNode(xmlNodePtr node) : EnvironmentNode()
{
    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (!strcmp((char*)node->name,"h2")) {
            child_nodes_.push_back(new HeadingNode(node, 2));
        } else if (!strcmp((char*)node->name,"h3")) {
            child_nodes_.push_back(new HeadingNode(node, 3));
        } else if (!strcmp((char*)node->name,"author")) {
            child_nodes_.push_back(new AuthorNode(node));
        } else if (!strcmp((char*)node->name,"date")) {
            child_nodes_.push_back(new DateNode(node));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
TitleNode::~TitleNode()
{
}


//---------------------------------------------------------------------------
void TitleNode::writeHTML(int parameter) const
{
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeHTML();
    }
}

//---------------------------------------------------------------------------
void TitleNode::writeLaTeX() const
{
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
}

//---------------------------------------------------------------------------
void TitleNode::writeXML() const
{
    Output_ << "<title>" << endl;
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</title>" << endl;
}


//---------------------------------------------------------------------------
int TitleNode::isHTMLStepped() const
{
    return 0;
}

//---------------------------------------------------------------------------
unsigned int TitleNode::getNumberOfHTMLSteps() const
{
    return 0;
}
