/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: sectionnode.cc,v $
 * Revision 1.3  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:32  slash
 * Initial release.
 *
 */

#include "main.h"
#include "slidenode.h"
#include "sectionnode.h"


//---------------------------------------------------------------------------
SectionNode::SectionNode(xmlNodePtr node) : Node()
{
    child_nodes_.clear();

    // Extract the properties of the grid-markup.
    title_ = (char*)xmlGetProp(node, (xmlChar*)"title");

    // Extract the slides in this section.
    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (!strcmp((char*)node->name,"slide")) {
            child_nodes_.push_back(new SlideNode(node));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
SectionNode::~SectionNode()
{
    child_nodes_.clear();
}


//---------------------------------------------------------------------------
void SectionNode::writeHTML(int parameter) const
{
    SlideNode::Section_Title_ = title_;
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeHTML(parameter);
    }
    SlideNode::Section_Title_ = NULL;
    SlideNode::Section_Filename_[0] = '\0';
}

//---------------------------------------------------------------------------
void SectionNode::writeLaTeX() const
{
    SlideNode::Section_Written_In_Outline_ = 0;
    SlideNode::Section_Title_ = title_;
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
    SlideNode::Section_Title_ = NULL;
    SlideNode::Section_Filename_[0] = '\0';
}

//---------------------------------------------------------------------------
void SectionNode::writeXML() const
{
    Output_ << "<section"
            << " title=\"" << title_ << "\""
            << ">" << endl << endl;
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</section>" << endl << endl;
}

//---------------------------------------------------------------------------
void SectionNode::writeTOCEntry() const
{
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        // If the section has a title, write it first.
        if ((i == 0) && title_) {
            Output_ << title_ << "</TD></TR>" << endl
                    << "<TR><TD>";
        }

        // If the section doesn't have a title,
        // don't write an indentation for the first slide.
        if ((i > 0) || title_) {
            for (int j=0; j<8; j++) {
                Output_ << "&nbsp;";
            }
        }

        child_nodes_[i]->writeTOCEntry();

        // The output of the last slide must not end with a new cell.
        if (i < child_nodes_.size()-1) {
            Output_ << "</TD></TR>" << endl
                    << "<TR><TD>";
        }
    }
}
