/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: tocinterface.h,v $
 * Revision 1.1.1.1  2001/01/30 18:36:39  slash
 * Initial release.
 *
 */

#ifndef TOCINTERFACE_H
#define TOCINTERFACE_H

//---------------------------------------------------------------------------
/**
 * This class just provides an interface for all nodes,
 * which should be able to create entries for the table of contents.
 */
class TOCInterface
{
  public:
    //-----------------------------------------------------------------------
    /**
     * This method writes the entry for the table of contents to the global
     * output filestream Output_.
     */
    virtual void writeTOCEntry() const = 0;
};

#endif //TOCINTERFACE_H
