/*****
*
* Copyright (C) 2001 Jeremie Brebec <flagg@ifrance.com>
* All Rights Reserved
*
* This file is part of the Prelude program.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by 
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
* Written by Jeremie Brebec <flagg@ifrance.com>
*
*****/


#ifndef RULES_OPERATIONS_H
#define RULES_OPERATIONS_H

#include "rules.h"


/*
 * copy a typed variable
 */
var_t *copy_var(var_t *dst, const var_t *src ); 

/*
 * create a rule(s)
 */
rules_t *make_new_rules( rule_t *rule, rules_t *next );
rule_t *make_new_rule( int id, void *set );
rule_t *make_data_rule( int id, void *data );

/*
 * delete a rule(s)
 *
 * warning, a rule cant be completly deleted, because data are shared
 */
void delete_rules( rules_t *rules );
void delete_rule( rule_t *rule );

/*
 * copy a rule(s)
 */
rules_t *copy_rules( rules_t *rules );
rule_t *copy_rule( rule_t *rule );

/*
 * logical operation on rule(s)
 */
rules_t *rules_and( rules_t *rules1, rules_t *rules2 );
rules_t *rules_or( rules_t *rules1, rules_t *rules2 );
rules_t *rule_and( rules_t *rules, rule_t *rule );
rules_t *rule_or( rules_t *rules, rule_t *rule );
rules_t *rule_not( rule_t *rule );
rules_t *rules_not( rules_t *rules );


/*
 * add/get data to a rule
 */
int add_rule_data( rule_t *rule, int id, void *data );
void *signature_engine_get_rule_data(rule_t *rule, int id);
void *signature_engine_get_data_by_id(data_t *data, int id);


/*
 * add a leaf_match function
 */
int add_rule_leaf_match(rule_t *rule, int rid, void *rdata, leaf_match_f_t leaf_match);

/*
 * check rule integrity
 */
int check_rule_integrity( rule_t *rule );

/*
 * validate rule(s)  (i.e. sort them for add_rule(s) )
 */
int validate_rules( rules_t *rules ); 
int validate_rule( rule_t *rule );

/*
 * create an empty tree
 */
rules_node_t *make_rules_root(void);

/*
 * copy and delete a node
 */
rules_node_t *copy_rules_node( rules_node_t *node );
void delete_rules_node( rules_node_t *node );

unsigned int signature_engine_get_new_data_id(void);

#endif
