#
#
#
#

set lmenu_proc(get)		lmenu:get
set lmenu_proc(add)		lmenu:add
set lmenu_proc(post)		lmenu:post
set lmenu_proc(unpost)		lmenu:unpost
set lmenu_proc(activate)	lmenu:activate

Widget:DefineClass ListboxMenu {} lmenu:create lmenu:config lmenu_proc

set lmenu_height 8
set lmenu_prev_focus ""

option add *ListboxMenu*font "-*-helvetica-medium-r-normal-*-12-*"
option add *ListboxMenu*background "#d9d9d9"
option add *ListboxMenu*foreground "black"

proc lmenu:create {w a} {
    toplevel $w.menuToplevel
    wm withdraw $w.menuToplevel
    wm overrideredirect $w.menuToplevel true
    wm focusmodel $w.menuToplevel active

    listbox $w.menuToplevel.itemList -relief sunken -height 0 \
	-highlightthickness 0 \
	-yscrollcommand "$w.menuToplevel.yscroll set"
    scrollbar $w.menuToplevel.yscroll -orient vertical \
	-command "$w.menuToplevel.itemList yview"

    set lmenu_conf($w,variable) ""

    pack $w.menuToplevel.itemList -side left -fill both -expand yes
    pack $w.menuToplevel.yscroll -side left -fill y

    bind $w.menuToplevel <ButtonRelease-1> {lmenu:select %W %x %y}
    bind $w.menuToplevel.itemList <Key-Return> {lmenu:select %W -1 -1}
    bind $w.menuToplevel.itemList <Key-Escape> {lmenu:cancel %W}
}

proc lmenu:config {w opt val} {
    switch -- $opt {
	-width {
	    $w.menuToplevel.itemList configure -width $val
	}
	-height {
	    $w.menuToplevel.itemList configure -height $val
	}
	-scrollbarwidth {
	    $w.menuToplevel.yscroll configure -width $val
	}
	-variable {
	    global lmenu_conf
	    set lmenu_conf($w,variable) $val
	}
	default {
	    return 1
	}
    }
    return 0
}

proc lmenu:post {w a} {
    global lmenu_prev_focus

    set lmenu_prev_focus [focus]

    if {[llength $a] < 2} {
	set p [winfo parent $w]
	set x [winfo rootx $p]
	set y [expr [winfo rooty $p] + [winfo height $p]]
    } else {
	set x [shift a]
	set y [shift a]
    }
    wm geometry $w.menuToplevel +$x+$y
    wm deiconify $w.menuToplevel

    grab set -global $w.menuToplevel
    raise $w.menuToplevel
    focus $w.menuToplevel.itemList
}

proc lmenu:unpost {w a} {
    global lmenu_prev_focus

    grab release $w.menuToplevel
    wm withdraw $w.menuToplevel

    if {$lmenu_prev_focus != ""} {
	focus $lmenu_prev_focus
    }
}

proc lmenu:get {w a} {
    eval $w.menuToplevel.itemList get $a
}

proc lmenu:add {w a} {
    global lmenu_height

    foreach i $a {
	set h [$w.menuToplevel.itemList cget -height]
	if {$h <= $lmenu_height} {
	    incr h
	    $w.menuToplevel.itemList configure -height $h
	}
	$w.menuToplevel.itemList insert end $i
    }
}

proc lmenu:activate {w a} {
    set i [lindex $a 0]
    $w.menuToplevel.itemList activate $i
    $w.menuToplevel.itemList selection set $i $i
}

proc lmenu:this_widget {w} {
    winfo parent [winfo toplevel $w]
}

proc lmenu:select {w x y} {
    set result ""
    set widget [lmenu:this_widget $w]

    if [regexp {\.menuToplevel$} $w] {
	lmenu:unpost $widget {}
    } elseif [regexp {\.itemList} $w] {
	if {$x > 0} {
	    tkCancelRepeat
	    $w activate @$x,$y
	}
	set c [$w curselection]
	if {$c >= 0} {
	    set result [$w get $c]
	}
	global lmenu_conf
	if {[info exists lmenu_conf($widget,variable)] &&
	$lmenu_conf($widget,variable) != ""} {
	    upvar \#0 $lmenu_conf($widget,variable) var
	    set var $result
	}
	lmenu:unpost [lmenu:this_widget $w] {}
    }
    return $result
}

proc lmenu:cancel {w} {
    lmenu:unpost [lmenu:this_widget $w] {}
    return ""
}

proc lmenu:test {} {
    button .b -textvariable lmenu_test_var
    ListboxMenu .b.menu -variable lmenu_test_var
    .b.menu add aho0 baka0 tawake0
    .b.menu add aho1 baka1 tawake1
    .b.menu add aho2 baka2 tawake2
    .b.menu add aho3 baka3 tawake3

    .b configure -command {.b.menu post}
    pack .b
}
