/*
 * pptpgre.h
 *
 * Functions to handle the GRE en/decapsulation
 *
 * $Id: pptpgre.h,v 1.2 1999/12/23 21:43:33 patl Exp $
 */

#ifndef _PPTPD_PPTPGRE_H
#define _PPTPD_PPTPGRE_H

#include "pptpdefs.h"

#define GRE_PACKET_SIZE 2048
#define HDLC_PACKET_SIZE (2*GRE_PACKET_SIZE + 6)

/* Variables to control the packet reordering scheme:
 *  PCKT_REORDER_SIZE
 *     this is the number of packets ahead of the current packet that
 *     will get buffered while waiting for a packet.  If a new packet
 *     comes in more than this far ahead, we stop waiting for the missing packet
 *
 *  PCKT_REORDER_RESUME_SIZE
 *     if this many consecutive packets are available in the buffer
 *     while we are waiting for a lost packet, then we will stop waiting
 *     for the missing packet
 *
 *  PCKT_REORDER_WAIT_TIME
 *     if a new packet comes in and this many seconds have expired since
 *     we last passed on a packet to pppd, then we will stop waiting
 *     for the missing packet
 */
#define PCKT_REORDER_SIZE 12
#define PCKT_REORDER_RESUME_SIZE 3
#define PCKT_REORDER_WAIT_TIME 2

enum gre_header_type { GRE_HEAD_ONE, GRE_HEAD_BOTH };

struct gre_xmit_packet {
  union {
    struct {
      struct pptp_gre_header header;
      u_int32_t seq;
      u_int32_t ack;
    } both;
    struct {
      u_int32_t pad;
      struct pptp_gre_header header;
      u_int32_t seq_or_ack;
    } one;
  } head;
  unsigned char data[GRE_PACKET_SIZE];
};

struct gre_rcv_packet {
  struct pptp_gre_header header;
  union {
    struct {
      u_int32_t seq;
      u_int32_t ack;
      unsigned char data[GRE_PACKET_SIZE];
    } both;
    struct {
      u_int32_t seq_or_ack;
      unsigned char data[GRE_PACKET_SIZE];
    } one;
  } body;
};

struct gre_state {
  u_int32_t ack_sent, ack_recv;
  u_int32_t seq_sent, seq_recv;
  u_int32_t call_id_pair;
  u_int16_t xmit_window_size;
  u_int16_t xmit_max_window_size;

  /* TTY input state */
  int pty_bytes_read;
  int pty_bytes_processed;
  int pty_last_char;
  int pty_escape;
  unsigned char pty_input_buffer[HDLC_PACKET_SIZE];
  u_int16_t fcs;

  /* GRE output state */
  int gre_fd;
  u_int16_t gre_packet_size;
  struct gre_xmit_packet gre_packet;
  int gre_packet_ready;

  /* GRE input state */
  struct gre_rcv_packet window[PCKT_RECV_WINDOW_SIZE+1];
  int gre_current_packet;
  int gre_num_packets;
  int gre_last_recv_time;

  /* PTY output state */
  int pty_fd;
  unsigned char pty_output_buffer[HDLC_PACKET_SIZE];
  int pty_output_size;
  int pty_bytes_written;
};

extern struct gre_state *pptp_gre_init(u_int32_t call_id_pair,
                                       u_int16_t max_window_size,
                                       int pty_fd,
                                       struct in_addr *inetaddrs);
extern int do_pty_to_gre (struct gre_state *gre);
extern int do_gre_to_pty (struct gre_state *gre);

#endif	/* !_PPTPD_PPTPGRE_H */
