#!/bin/sh

PACKAGE=pppoeconf

if [ "$1" == "clean" ] ; then
   echo Removing garbage...
   rm -rf usr *.old.* *~ *.pot
   exit 0
fi

set -e

#mv -f pppoeconf.pot pppoeconf.pot~
bash --dump-po-strings ../$PACKAGE > pppoeconf.pot
#msgmerge pppoeconf.pot.old pppoeconf.pot.new  > pppoeconf.pot

for x in de fr pt_BR ; do
   cp $x.po $x.old.po
   echo -n "Updating $x.po: "
   echo -e '# fuzzy\nmsgid ""\nmsgstr ""' > tmp~
   grep '^.MIME-Version\|^.Content-Type\|^.Content-Transfer-Encoding' $x.po >> tmp~
   cat pppoeconf.pot >> tmp~
   msgmerge $x.old.po tmp~ > $x.po~ && mv $x.po~ $x.po
   mkdir -p usr/share/locale/$x/LC_MESSAGES
   echo "Compiling $x.mo..."
   msgfmt -o usr/share/locale/$x/LC_MESSAGES/$PACKAGE.mo $x.po
   
#   msgmerge $x.old.po pppoeconf.pot > $x.po && rm $x.old.po
done
