/*
 *  $Id: xml.c,v 1.8 2001/10/01 21:45:35 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 * XML routines used by PCI backend.
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <powertweak.h>
#include <string.h>
#include <parser.h>

#include "pci.h"


#define match_record(text,variable) \
		do { if (strcasecmp((char*)cur->name, (text))==0) \
			(variable) = (char *) xmlNodeListGetString(doc, cur->xmlChildrenNode, 1);} while (0)

#define match_record3(text,variable,func) \
		do { char *CHPTR; \
		     CHPTR = (char*)xmlNodeListGetString(doc,cur->xmlChildrenNode,1); \
		     if ( (strcasecmp((char*)cur->name, (text))==0) && \
			 (CHPTR!=NULL) ) \
			(variable) = func(CHPTR); free(CHPTR);} while (0)




static void do_one_item (xmlDocPtr doc, xmlNsPtr pt_unused ns, xmlNodePtr cur, struct pci_dev *dev)
{
	struct tweak *tweak = NULL;
	struct private_PCI_data *private = NULL;
	char *Frame = NULL, *Group = NULL;
	char *Tab = "Tweaks";
	xmlChar *XMLProp;

	/* First, allocate the structures for one item */
	tweak = alloc_PCI_tweak (dev, TYPE_NODE_ONLY);
	if (tweak == NULL)
		return;
	private = tweak->PrivateData;


	/* Then iterate over all XML elements and fill the structure */
	assert (cur != NULL);

	XMLProp = xmlGetProp (cur, "base");
	private->base_address = strtoul (XMLProp, NULL, 0);
	free(XMLProp);

	XMLProp = xmlGetProp (cur, "offset");
	if ( XMLProp!= NULL)
		private->address_offset = strtoul (XMLProp, NULL, 0);
	free(XMLProp);

	XMLProp = xmlGetProp (cur, "bit");
	if (XMLProp != NULL) {
		unsigned long bitnr;
		bitnr = strtoul (XMLProp, NULL, 0);
		private->Mask = 1 << bitnr;
		private->OnMask = 1 << bitnr;
		private->OffMask = 0 ;
	}
	free(XMLProp);
	cur = cur->xmlChildrenNode;
	while (cur != NULL) {
		assert (cur->name != NULL);

		match_record ("FRAME", Frame);
		match_record ("GROUP", Group);
		match_record("WIDGETTEXT", tweak->WidgetText);

		if (private->base_address > 255) {
			printf ("%s has a PCI configspace offset of %lx!",
				tweak->WidgetText, private->base_address);
			if (tweak->Destroy)
				tweak->Destroy(tweak);
			free (tweak);
			return;
		}
		
		match_record3("TYPE", tweak->Type, string_widget_to_int);
		if (tweak->Type == TYPE_CHECKBOX ||
			tweak->Type == TYPE_INFO_BOOL) {
			tweak->MinValue = 0;
			tweak->MaxValue = 1;
		} else {
			match_record3("LOW", tweak->MinValue, atoi);
			match_record3("HIGH", tweak->MaxValue, atoi);
		}
		match_record("DESCRIPTION", tweak->Description);
		match_record3("BITMASK", private->Mask, bitstring_to_long);	
		match_record3("ONBITS", private->OnMask, bitstring_to_long);	
		match_record3("OFFBITS", private->OffMask, bitstring_to_long);	
		
		if (!strcasecmp (cur->name, "CONFIGNAME")) {
			char *XMLstr;
	
			tweak->ConfigName = malloc (CONFIGNAME_MAXSIZE);
			if (tweak->ConfigName == NULL) {
				if (tweak->Destroy)
					tweak->Destroy(tweak);
				free (tweak);
				return;
			}
			XMLstr = (char *) xmlNodeListGetString (doc, cur->xmlChildrenNode, 1);
			snprintf (tweak->ConfigName,CONFIGNAME_MAXSIZE, "%.4x%.4x_%02x:%02x:%02x_%s",
					dev->vendor_id, dev->device_id,
					dev->bus, dev->dev, dev->func,
					XMLstr);
			if (XMLstr!=NULL)
				free(XMLstr);
		}	
			

		cur = cur->next;

	}

	if (!fill_struct_tweak_from_PCI (tweak)) {
		if (tweak->Destroy)
			tweak->Destroy(tweak);
		free (tweak);
		if (Frame != NULL)
			free(Frame);
		return;
	}

	/* FIXME: doesn't respect --no-info. */
	AddTo_PCI_tree (tweak, dev, Frame, Tab, Group, TRUE);
	if (Frame != NULL)
		free(Frame);
}


static void parse_file (xmlDocPtr doc, xmlNsPtr ns, xmlNodePtr cur)
{
	struct pci_dev *dev;

	word xmlVendor;
	word xmlDevice;


	if (cur == NULL)
		return;

	if ((cur->name != NULL) && (strcasecmp (cur->name, "DEVICE") == 0)) {
		xmlChar *VendorStr,*IDStr;

		VendorStr = xmlGetProp (cur, "vendor");		
		IDStr = xmlGetProp (cur, "id");
		assert (VendorStr != NULL);
		assert (IDStr!= NULL);

		xmlVendor = strtoul (VendorStr, NULL, 0);
		xmlDevice = strtoul (IDStr, NULL, 0);
		
		free(VendorStr);
		free(IDStr);

		dev = pacc->devices;

		while (dev) {
			if ((dev->vendor_id == xmlVendor) && (dev->device_id == xmlDevice)) {

				cur = cur->xmlChildrenNode;
				while (cur != NULL) {
					if ((cur->name != NULL) && (strcasecmp (cur->name, "REGISTER") == 0))
						do_one_item (doc, ns, cur, dev);
					cur = cur->next;
				}
				return;
			} else {
				dev = dev->next;
			}
		}
	}
}

void load_PCI_xmlfile (char *Filename)
{
	xmlDocPtr doc;
	xmlNodePtr cur;

	if (Filename == NULL)
		return;

	doc = xmlParseFile (Filename);
	if (doc == NULL) {
		printf ("Severe XML error: doc == NULL!!\n");
		printf ("Probable cause: file %s not found.\n", Filename);
		return;
	}

	cur = xmlDocGetRootElement(doc);
	if (cur == NULL) {
		printf ("Severe XML error: cur == NULL");
		xmlFreeDoc(doc);
		return;
	}

	parse_file (doc, NULL, cur);
	xmlFreeDoc(doc);
}
