/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 *               Author(s): Holger Macht <hmacht@suse.de>                  *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#ifndef POWERSAVE_ACPI_H
#define POWERSAVE_ACPI_H

#include "pm_interface.h"

using namespace std;

class ACPI_Interface : public PM_Interface {
public:
	/** @brief default initialisation */
	 ACPI_Interface();

	/** @brief destructor */
	 virtual ~ ACPI_Interface();

	/** @brief opens the acpi event file
	 *
	 * @return the filedescriptor or -1 on error
	 * @retval < 0 on error
	 * @retval the filedesctiptor on success
	 */
	virtual int openHWEventFD();

	/** @brief Handles an event on the socket
	 *
	 * @return integer value with result if handle event
	 * @retval 1 if an event has been generated
	 * @retval 0 if no event has been generated
	 * @retval -1 on fatal errors
	 * @retval -2 if acpid shuts down/ socket is missing
	 */
	virtual int handleHWEventRequest(int fd = -1);

	/** @brief get time in millisecs since 1970
	 *
	 * @return time in milliseconds since 1970
	 */
	unsigned long getTimestamp();

	/** @brief opens the socket provided by acpid 
	 *
	 * @return the filedescriptor or < 0 on error
	 */
	virtual int openAcpidSocket();

	/** @brief activates settings for specific scheme 
	 *
	 * throttling and thermal control only in ACPI
	 */
	virtual void activateSettings();

	/** @brief event file for acpi events
	 *
	 * this is now configurable via -f parameter it could be either
	 * the acpid socket or the kernel acpi event file
	 */
	static string ACPI_EVENTFILE;

private:
	/** @brief sets the battery alarm of the current scheme
	 *
	 * @return integer value with the result of set batteryalarm.
	 *         Also returns true if not supported
	 *
	 * @retval - 1 on success
         * @retval -1 if alarm could not be set or is not supported
	 */
	int setBatteryAlarm_();

	/** @brief workaround for buggy double button events
	 *
	 * only allow one button event(sleep/power)
	 * inside the time window below (in millisecs)
	 */
	unsigned long _last_button_occurence;

};

#endif // POWERSAVE_ACPI_H
