//******************************************************************************
// file						: "noassembler.cpp"
// created	 			: 2000-04-22
// updates				: 2000-04-02
// functions      : rewrite "assembler.S" in C/C++
// programmers 		: Bruno Ethvignot (bruno@tlk.fr)
// copyright			:	TLK Games (http://www.tlk.fr)
//
// This program is free software; you can redistribute it and/or modify it under the terms of the 
// GNU General Public License as published by the Free Software Foundation; either version 2 of the License, 
// or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//  
// You should have received a copy of the GNU General Public License along with this program; 
// if not, write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
//******************************************************************************
#include "powermanga.hpp"
#include <string.h>
typedef struct  _compress {
	unsigned int offset ;						//offset
	unsigned short r1 ;							//
	unsigned short r2 ;
} _compress ;

//-----------------------------------------------------------------------------
// display fontes 8*8 pixels (8 / 16 / 24 or 32 bits) 
//				=> _pDestination	:	buffer destination address
//				=> _iX						: offset destination
//				=> _iY						: offset destination
//				=> _iCouleur			: couleur
//				=> _iLarge				: largeur
//				=> _iHaute				: hauteur
//													: Bruno Ethvignot
//-----------------------------------------------------------------------------
void _putRectangle16bits(char* adresse, int x, int y, int coul, int large, int haute)
{	unsigned short* d1=(unsigned short*)(adresse+(y<<10)+x*2) ;
	unsigned short* d2=(d1+(haute<<9)) ;
	int l=large ;
	unsigned short* d3=d1 ;
	unsigned short* d4=d3+l ;
	do
	{	*(d1+l)=coul ;
		*(d2+l)=coul ;
		l-- ;
	} while(l>=0) ;
	l=haute<<9 ;
	do
	{	*(d3+l)=coul ;
		*(d4+l)=coul ;
		l-=256 ;
	} while(l>=0) ;
}

//-----------------------------------------------------------------------------
// display fontes 8*8 pixels (8 / 16 / 24 or 32 bits) 
// entree 	=> _pSource 			: buffer source address 
//				=> _pDestination	:	buffer destination address
//				=> _iOffsetS			: offset source
//				=> _iOffsetD			: offset destination
//													: Bruno Ethvignot
//-----------------------------------------------------------------------------
void	_asmCopyFonte16Bits(unsigned char* _pSource, unsigned char* _pDestination, unsigned int _iLarge, unsigned int _iHaut, unsigned int _iOffsetS, unsigned int _iOffsetD)
{	unsigned short* s=(unsigned short*)_pSource ;
	unsigned short* d=(unsigned short*)_pDestination ;
	_iOffsetS=_iOffsetS/2 ; _iOffsetD=_iOffsetD/2 ;
	for(unsigned int h=0 ; h<_iHaut ; h++)
	{	for(unsigned int l=0 ; l<_iLarge ; l++)
		{	unsigned short p=*(s++) ;
			if(p!=0) *d=p ;
			d++ ;
		}
		s=s+_iOffsetS ;	d=d+_iOffsetD ;	
	}
}

//-----------------------------------------------------------------------------
//affiche sprite en  8 / 16 / 24 or 32 bits 
//entree 	=> _pGfx 				: buffer source address 
//				=> _pBuffer			:	buffer destination address
//				=> _pTable			: 'compress' address table
//				=> _iTaille			: number of pixels 
//Linux port							: Bruno Ethvignot
//-----------------------------------------------------------------------------
//(16 bits)#####################################################################
void _putsprite3_16bits(char* _pSource, char* _pDestination, char* _pCompression, unsigned int _iTaille) 
{	unsigned short* s=(unsigned short*)_pSource ;
	unsigned short* p=(unsigned short*)_pDestination ;
	_compress* t=(_compress*)_pCompression ;
	do
	{	register unsigned int d=t->offset ; d=d>>1 ;
		p=p+d ;
		unsigned short z=t->r1 ;
		unsigned int* s2=(unsigned int*)s ;
		unsigned int* p2=(unsigned int*)p ;
		//for(unsigned int i=0 ; i<z ; i++) { p2[i]=s2[i] ; }
		memcpy(p2, s2, z*4) ;
		p2=p2+z ; s2=s2+z ;
		s=(unsigned short*)s2 ;
		p=(unsigned short*)p2 ;
		z=t->r2 ;
		//for(unsigned int i=0 ; i<z ; i++) { p[i]=s[i] ; }
		memcpy(p2, s2, z*2) ;
		p=p+z ; s=s+z ;
		t++ ;
		_iTaille=_iTaille-1 ;
	}
	while(_iTaille>0) ;
}

//-----------------------------------------------------------------------------
//display sprite s mask (8 bits per pixel)
//entree 	=> _iColor	 			: color en 8/16/24/32 bits 
//				=> _pDestination	:	adresse du buffer destination
//				=> _pCompress			: adresse table 'compress'
//				=> _iTaille				: nombre de pixels a traiter
// Linux port								: Bruno Ethvignot
//------------------------------------------------------------------------------
void		_putsprcolor_16bits(unsigned int _iColor, char* _pDestination, char* _pCompression, unsigned int _iTaille)
{	unsigned short* p=(unsigned short*)_pDestination ;
	_compress* t=(_compress*)_pCompression ;
	do
	{	unsigned int d=t->offset ; d=d>>1 ;
		p=p+d ;
		unsigned short z=t->r1 ;
		unsigned int* p2=(unsigned int*)p ;
		memset(p2, _iColor, z*4) ;
		p2=p2+z ;
		p=(unsigned short*)p2 ;
		z=t->r2 ;
		memset(p2, _iColor, z*2) ;
		p=p+z ;
		t++ ;
		_iTaille=_iTaille-1 ;
	}
	while(_iTaille>0) ;
}

//------------------------------------------------------------------------------
// 
//------------------------------------------------------------------------------
void conv8to16(char* _pSource, char* _pDestination, unsigned short* _pPalette16, unsigned int _iTaille)
{	conv8_16(_pSource, _pDestination, _pPalette16, _iTaille) ;
}







