/*
UserOptions.h
*/

#ifndef __USEROPTIONS_H
#define __USEROPTIONS_H

#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>
#include <signal.h>

#include "Utils.h"
#include "Config.h"
#include "Configuration.h"
#include "XString.h"
#include "XVector.h"
#include "CCLIENT.h"
#include "Skin.h"

typedef XVector<XString> StringList;

#define DEF_USEROPT_FILE "\n[main]\n"                                                        \
                         "displaypersonalinfo="STR(DEFOPT_DISPLAYPERSONALINFO)"\n"           \
                         "msgsperindexpage="STR(DEFOPT_MSGSPERINDEXPAGE)"\n"                 \
                         "personalname=\n"                                                   \
                         "insigninnewmsg="STR(DEFOPT_INSERTSIGNATUREINNEWMSG)"\n"            \
                         "savemsgsentmail="STR(DEFOPT_SAVEMSGSENTMAIL)"\n"                   \
                         "replyfrom="STR(DEFOPT_REPLYFROM)"\n"                               \
                         "forwattachs="STR(DEFOPT_FORW_ATTACHS)"\n"                          \
                         "heightwritearea="STR(DEFOPT_HEIGHTWRITEAREA)"\n"                   \
                         "widthwritearea="STR(DEFOPT_WIDTHWRITEAREA)"\n"                     \
                         "truncatelengthreadingmsg="STR(DEFOPT_TRUNCATELENGTHREADINGMSG)"\n" \
                         "confirmpurge="STR(DEFOPT_CONFIRMPURGE)"\n"                         \
                         "showclock="STR(DEFOPT_SHOWCLOCK)"\n"                               \
                         "confirmlogout="STR(DEFOPT_CONFIRMLOGOUT)"\n"                       \
                         "skin="DEFOPT_SKIN"\n"                                              \
                         "refreshtime="STR(DEFOPT_REFRESHTIME)"\n"                           \
                         "sentmailname="DEFOPT_SENTMAILBOX"\n\n"

class UserOptions
  {
  private:
    Configuration *TheConf;
    TBuffer StatusLine, LastCmd, mount_points;
    XString user, imapserver, basepath, userdir, userattdir, userdatabasesdir, fnuseroptions, fnsignature, 
      fnsubscribedgroups, fnrcgroups, fnsavedmsg, fnsavednntpmsg, SentmailName, 
      XSTrueFileNameAttach, fnsieve, deniedservices, trueemail;
    bool InsertSignatureInNewMsg, SaveMsgSentMail, ForwAttachs, ReplyFrom, WorkingWithCookies, UseJavaScript,
         ConfirmPurge, ConfirmLogout, ShowClock, ShowIconsLabels, DisplayPersonalInfo, ShowCalendarTodayEvents;
    long MsgsPerIndexPage, CurrentPosition, TotalMsgs, MAILBOXSIZE, BeginPage;
    XString personalname, signature;
    int msgtoanswer, validator, pageid, lastcmd, sort_ab, TruncateLengthReadingMsg, WidthWriteArea, IconsSize,
        HeightWriteArea, RefreshTime, IMAPPORT, timeout, LastService, AuthSMTP, POPPASSPORT, FORWARDSPORT, SIEVEPORT,
        LDAPPORT, iAUTHSERVICE;
    StringList SLAttachList, SLAttachListInfo, PilaCmds;
    IPNAME MAILDOMAIN, IMAPSERVER, SMTPSERVER, NNTPSERVER, POPPASSSERVER, FORWARDSSERVER, SIEVESERVER, LDAPSERVER;
    TBuffer MAILBOXPREFIX, AUTHSERVICE;
  public:
    StringList *SLSubscribedGroups, *SLAllowedServices;
    UserOptions (const char *abasepath, const char *auser, const char *aimapserver);
    virtual ~UserOptions (); 
    void leeConf ();
    void InitStatusLine (void);
    const char *getStatusLine (void);
    void setStatusLine (const char *newstatusline, const char *htmlcolor);
    int getValidator (void);
    void IncValidator (void);
    void setCurrentPosition (long pos, long total);
    long getCurrentPosition (void);
    long getBeginPage (void);    
    void setMailboxSize (long asize);
    long getMailboxSize (void);    
    long getTotalMsgs (void);
    void setInsertSignatureInNewMsg (bool value);
    bool getInsertSignatureInNewMsg (void); 
    void setAuthSMTP (int value);
    int getAuthSMTP (void); 
    void setAuthService (const char *aservice);
    const char *getAuthService (void);
    int getiAuthService (void);    
    void setMailDomain (const char *amaildomain);
    const char *getMailDomain (void);
    void setImapServer (const char *aimapserver);
    const char *getImapServer (void);                  
    void setImapPort (int aimapport);
    int getImapPort (void);                  
    void setSieveServer (const char *asieveserver);
    const char *getSieveServer (void);
    void setSievePort (int apoppassport);
    int getSievePort (void);
    void setPoppassServer (const char *apoppassserver);
    const char *getPoppassServer (void);  
    void setPoppassPort (int apoppassport);
    int getPoppassPort (void);  
    void setLDAPServer (const char *aldapserver);
    const char *getLDAPServer (void);  
    void setLDAPPort (int aldapport);
    int getLDAPPort (void);
    void setForwardsServer (const char *aforwardsserver);
    const char *getForwardsServer (void);  
    void setForwardsPort (int aforwardsport);
    int getForwardsPort (void);                          
    void setSMTPServer (const char *asmtpserver);
    const char *getSMTPServer (void);  
    void setNNTPServer (const char *anntpserver);      
    const char *getNNTPServer (void);
    void setTrueEmail (const char *atrueemail);
    const char *getTrueEmail (void);  
    void setDeniedServices (const char *adeniedservices);
    const char *getDeniedServices (void);                      
    bool isDeniedService (const char *aservice);
    void setMailboxPrefix (const char *amailboxprefix);
    const char *getMailboxPrefix (void);
    const char *getUsername (void);
    const char *getUserDir (void);
    const char *getAttachDir (void);    
    const char *getDatabasesDir (void);        
    void setMsgsPerIndexPage (long value);
    long getMsgsPerIndexPage (void);
    void setPersonalName (char *value);
    const char *getPersonalName (void);    
    const char *getSieveFilename (void);
    void setDisplayPersonalInfo (bool value);
    bool getDisplayPersonalInfo (void);    
    void setShowCalendarTodayEvents (bool value);
    bool getShowCalendarTodayEvents (void);
    bool getSaveMsgSentMail (void);
    void setSaveMsgSentMail (bool value);    
    bool getShowClock (void);
    void setShowClock (bool value);        
    int getIconsSize (void);
    void setIconsSize (int value);        
    bool getShowIconsLabels (void);
    void setShowIconsLabels (bool value);
    void setReplyFrom (bool value);        
    bool getReplyFrom (void);
    void setForwAttachs (bool value);
    bool getForwAttachs (void);
    void setTruncateLengthReadingMsg (int value);
    int getTruncateLengthReadingMsg (void);
    void setWidthWriteArea (int value);
    int  getWidthWriteArea (void);    
    void setHeightWriteArea (int value);
    int  getHeightWriteArea (void);            
    void setRefreshTime (int value);
    int  getRefreshTime (void);            
    const char *getSignature (void);
    bool SaveOptions (char *tmpfilename, int cmd);    
    bool SaveNNTPOptions (char *tmpfilename);
    void LoadOptions (void);
    int numAttachs (void);
    const char *getFileNameAttach (int p);
    const char *getTrueFileNameAttach (int p);
    const char *getAttachInfo (int p);
    int addFileNameAtach (const char *newfile, const char *info);
    int delFileNameAtach (const char *attachnumbers);
    void delAllAttachs (void);
    void setSort_ab (int value);
    int getSort_ab (void);    
    const char *getfnSavedMsg (void);
    void setLastCmd (int value);
    int getLastCmd (void);        
    void clearPila (void);
    void vuelcaPila (void);
    void setPageId (int value);
    int getPageId (void);    
    const char *getLastStringCmd (int cmdactual, const char *lang, const char *connid, bool withhtml);    
    void addLastStringCmd (int cmd, const char *stcmd);
    void setNumMsgToReply (int value);
    int getNumMsgToReply(void);    
    bool IsWorkingWithCookies (void);
    void setWorkingWithCookies (bool b);
    bool get_use_javascript (void);
    void set_use_javascript (bool b);
    const char *getSentMailName (void);
    void setSentMailName (const char *smname);
    bool getConfirmPurge (void);
    void setConfirmPurge (bool b);
    bool getConfirmLogout (void);
    void setConfirmLogout (bool b);    
    void setTimeout (int value);
    int getTimeout (void);        
    void initSubscribedGroups();
    const char *getFileNameRcGroups (void);    
    int getObligatedGroups(TBuffer obligatedgroups);    
    bool SaveSubscribedGroups(void);
    void setLastService (int value);
    int getLastService (void);        
    void setMountPoints (const char *amount_points);
    const char *getMountPoints (void);        
  };

#endif

