/*
 * utmp.c	Write system and radius utmp files.
 *
 * Version:	#(#)utmp.c  1.00  12-Nov-1997  miquels@cistron.nl
 *
 */
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <utmp.h>
#include <time.h>
#include "server.h"

int update_utmp(const char *login_fmt, const char *from_fmt, const struct auth *ai, bool wtmp)
{
	struct utmp tmp, *utmptr;
	FILE *fp;
	pid_t pid;
	char tmp_str [256];

	if(!lineconf.sysutmp)
		return 0;

	pid = getpid();
	/*
	 *	Init should have setup this for us, so we
	 *	only update the entry if it exists (and only
	 *	at login - init does logout for us).
	 */
	setutent();
	while((utmptr = getutent()) != NULL) {
		if (utmptr->ut_pid == pid) {
			break;
		}
	}
	if (utmptr) {
		char *tty = lineconf.tty;
		if(!strncmp(tty, "/dev/", 5))
			tty += 5;
		tmp = *utmptr;
		expand_format (tmp_str, sizeof (tmp_str), login_fmt, ai);
		strncpy(tmp.ut_user, tmp_str, UT_NAMESIZE);
		expand_format (tmp_str, sizeof (tmp_str), from_fmt, ai);
		strncpy (tmp.ut_host, tmp_str, UT_HOSTSIZE);
		tmp.ut_type = USER_PROCESS;
		tmp.ut_time = time(NULL);
		strncpy(tmp.ut_line, tty, UT_LINESIZE);
		tmp.ut_addr = ai->address;
		setutent();
		pututline(&tmp);
		endutent();
		if (wtmp && (fp = fopen(WTMP_FILE, "a")) != NULL) {
			fwrite(&tmp, sizeof(tmp), 1, fp);
			fclose(fp);
		}
	}
	else
	{
		nsyslog(LOG_ERR, "No utmp entry found when expected for line %s.", lineconf.tty);
	}
	return 0;
}
