/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXMASS_FINDREPOPT_H
#define POLYXMASS_FINDREPOPT_H

#include "polyxmass-globals.h"



enum 
  {
    PXM_FIND_STRICT_IDENTICAL,
    PXM_FIND_STRICT_SUBSET,
    PXM_REPLACE_STRICT_IDENTICAL,
    PXM_REPLACE_STRICT_SUBSET,
  };

  typedef struct _PxmFindrepOpt PxmFindrepOpt;
  

  struct _PxmFindrepOpt
  {
    /* Not allocated GPtrArray.s
     */
    GPtrArray *findseqGPA;
    GPtrArray *repseqGPA;    
  
    gint find_start_idx;
    gint find_end_idx;
    
    gint rep_start_idx;
    gint rep_end_idx;
    
    /* This index allows to store the index at which iteration has
       attained during find/replace operations.
     */
    gint current_idx;
    
    gboolean find_only;

    gboolean backward;
        
    gint find_strictness;
    gint replace_strictness;
  };
  
  
  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmFindrepOpt *
  polyxmass_findrepopt_new (void);
  
  
  
  
  
  
  /* FREE'ING FUNCTIONS
   */
  
  gboolean 
  polyxmass_findrepopt_free (PxmFindrepOpt *findrepopt);
  
  
  
  
  
  
  
  
  
  
#endif  /*POLYXMASS_FINDREPOPT_H*/








