#xmlOutput takes the results of the pattern analysis run on SELinux and
#outputs an xml file in which the processes and resources found in the analysis
#are treated as nodes, and the interaction amongst the processes and resources
#are treated as edges. When a process or resource is found to be part of a pattern
#the xml node is assigned the color red; otherwise the node is assigned the color
#blue. The resulting xml  file can be opened with visualization products such as
#Hypergraph and Royere (gvf), without any modifications needed.
# August 3, 2004
#To use this file, after the analysis has been done import this file and call
#writeFile('your output file name')

import domain_model
import util
import os

def writeXMLFileHeading(f):
    f.write('<?xml version="1.0"?>\n')
    f.write('<!DOCTYPE GraphXML SYSTEM "file:GraphXML.dtd">\n')
    f.write('<!--Comment -->\n')
    f.write('<GraphXML>\n')
    f.write('\t<graph id = "SELinux">\n')
    f.write('\t\tsize width="1.2" height=1.2"/>\n')
    f.write('\t\t<style>\n')
    f.write('\t\t\t<fill tag="node" class="IP" colour = "red"/>\n')
    f.write('\t\t\t<fill tag="node" class ="IR" colour = "red"/>\n')
    f.write('\t\t\t<fill tag="node" class="NP" colour = "blue"/>\n')
    f.write('\t\t\t<fill tag="node" class ="NR" colour = "blue"/>\n')
    f.write('\t\t\t<line tag="edge" class = "In" colour="red" />\n')
    f.write('\t\t\t<line tag="edge" class = "NotIn" colour="cyan" />\n')
    f.write('\t\t</style>\n\n')

def areYouA(item, type):
    if item.__class__.__name__ == type:
        return 1
    else:
        return 0

def writeNode(file, resource):
        inPattern = 0
        Process = 0
	if areYouA(resource,'Process'):
            Process = 1
	    for e in resource.out_edges:
		    if len(e.meanings)>0:
                        inPattern = 1
            for e in resource.in_edges:
                    if len(e.meanings) >0:
                        inPattern = 1
        else:
            for e in resource.out_edges:
		    if len(e.meanings)>0:
                        inPattern = 1
            for e in resource.in_edges:
                    if len(e.meanings) >0:
                        inPattern = 1
        if inPattern == 1:
            if Process == 1:
                file.write('<node name = "' + resource.id + '" class = "IP">')
                file.write('<label>"' + os.path.basename(resource.name) + '"</label>\n')
                file.write('<size width="2.0" height="2.0"/></node>\n')
	    else:
                file.write('<node name = "' + resource.id + '" class = "IR">')
                file.write('<label>"' + os.path.basename(resource.name) + '"</label>\n')
                file.write('<size width="0.5" height="0.5"/></node>\n')
	else:
            if Process == 1:
		file.write('<node name="' + resource.id +  \
                           '" class = "NP">')
		file.write('<label>"' + os.path.basename(resource.name) + '"</label>\n')
		file.write('<size width="2.0" height="2.0"/></node>\n')
            else:
                file.write('<node name="' + resource.id +  \
                           '" class = "NR">')
		file.write('<label>"' + os.path.basename(resource.name) + '"</label>\n')
		file.write('<size width="0.5" height="0.5"/></node>\n')

def writeEdge(file, resource):
    inPattern = 0
    if len(util.trans[resource]) > 0:
        for e in resource.out_edges:
	    if len(e.meanings)>0:
                file.write('<edge source="' + resource.id + '" target="' +\
                          e.range.id +'" class = "In" />\n')
            else:
                    file.write('<edge source="' + resource.id + '" target="' +\
                          e.range.id +'" class = "NotIn" />\n')
           #print "\t" + str(util.trans[resource][l])

def writeFileEnding(file):
    file.write('\n</graph>\n')
    file.write('</GraphXML>')

def writeFile(f):
    #filePathAndName = 'c:\Documents and Settings\mlazo\My Documents\SELinux\\' + filename +".txt"
    f=open(f, 'w')
    writeXMLFileHeading(f)
    for v in util.resources_dict.values():
        writeNode(f, v)
    for k in util.trans.keys():
        writeEdge(f, k)
    writeFileEnding(f)

#writeFile('c:\Documents and Settings\mlazo\My Documents\GraphDemos\TEST.xml')
