import os
import os.path
resources_dict = {}

actions = {}
applications = []
trans = {} # dictionary of dictionaries parameterized by domain then range

#global normalized_trans
normalized_trans = {} # dictionary parameterized by context-context-action]
global PRGM
PRGM = None

uid2name = {}

operator_sequence = {}

class Source:
    def __init__(self, name):
        self.name = name
        self.files = []
        self.program = PRGM
        self.resources = {}
        PRGM.sources.append(self)
        
class Program:
    def __init__(self, name):
        global PRGM
        self.name = name
        self.name_for_type = name.lower()
        self.gen_nbr = 1
        self.debug = False
        self.external_connections = []
        self.sources = []
        self.next_pid = 1000
        self.operator_nbr = 1
        self.history_nbr = 1
        self.new_contexts = []
        self.pattern_instances = {}
        PRGM = self
        
class UID:
    """ uid's are needed for gui.  in many cases, we will
    want to retrieve objects either via the name or the uid.
    gen_uid is a protyotype holding the last assigned numberical value"""
    def __init__(self):
        self.value = 0
    def bump(self):
        self.value = self.value + 1
        return str(self.value)

uid_gen = UID()

def user_and_role (context):
    there = context.split(':')
    if len(there) > 1:
        return there[0] + ':' + there[1] + ':'
    else:
        return ""

def stype (context):
    there = context.split(':')
    if len(there) > 1:
        return there[-1]
    else:
        return ""

def context2type (context):
    if context[-1:] == '\n':
        context = context[:-1]
    return context.split(':')[-1]

def ensure_directory_exists(dir_path):
    """ /** If a directory does not exists it will be created
         *
         *   @param strPath - a string representing a path
         *
         *   @return true if the directory was correctlly established
         */
    """
    if not os.path.exists(dir_path):
        try:
            os.makedirs(dir_path)
        except:
            print "cannot create directory"
            return 0
    if not os.path.isdir(dir_path):
        return 0
    return 1



def get_current_program():
    return PRGM

def get_prgm_classes ():
    return [resources_dict[x] for x in process_ids()]


        
###### Utilities ###################

def process_ids ():
    return [x for x in resources_dict.keys() if \
            the_type(resources_dict[x]) == 'Process']

def strip_commas (lst):
    str = "{"
    for item in lst:
        str = str + item + " "
    str = str + "}"
    return str

def cross_product (set):
    toreturn = []
    for x in set:
        for y in set:
            toreturn.append([x, y])
    return toreturn

def intersect (A, B):
    return [x for x in A if x in B]

def dashes (intNbr):
    """ /** create a string with intNbr of '-'
         *
         *  @author -
         *
         *  @param intNbr - the number of '-' that will appear in the string
         *
         *  @return the created string
         */
    """
    ans = ""
    count = 0
    while count < intNbr:
        count = count + 1
        ans = ans + "-"
    return ans

def spaces (intNbr):
    """ /** Creates string with (4 x intNbr) spaces.
         *
         *  @author
         *
         *  @param intNbr- integer representing 1/4 the number of spaces needed
         *
         *  @return resulting string
         */
    """
    if intNbr <= 0:
        return ""
    else:
        ans = ""
        count = 0
        while count < intNbr:
            ans = ans + "    "
            count = count + 1
        return ans

def empty (lst):
    """ /** Determine if the collection is empty or not
         *
         *  @author - DRH
         *  @author AA
         *
         *  @modified AA - 07/23/01 19:35
         *
         *  @param lst - any collection
         *
         *  @return 1 if the collection is not empty, otherwise 0
         */
    """
    if len(lst) == 0:
        return 1
    else:
        return 0

def isES (lst):
    """ /** determines if list is the empty set
         *
         *  @author - DRH
         *
         *  @param lst - collection being tested
         *
         *  @return boolean
         */
    """
    return empty(lst)

def Exists (lst):
    """ /** determines if list contains items
         *
         *  @author - DRH
         *
         *  @param lst - collection being tested
         *
         *  @return boolean
         */
    """
    return not isES(lst)

def setdiff (A, B):
    return [a for a in A if a not in B]

def dict_put (dic, key, value): # was dictPut (dic, key, value):
    """ /** puts values in a dictionary for a specified key.  If a value
         * already exists for that key, it appends value."""
    if dic.has_key(key):
        dic[key].append(value)
    else:
        dic[key] = [value]



def flatten (nested_list):
    toreturn = []
    for x in nested_list:
        toreturn = toreturn + x
    return toreturn

def obj_name_contains_one_of(obj, strlst):
    if obj == None:
        return 0
    else:
        its_name = obj.name
        for l in strlst:
            if contains_str(its_name, l):
                return 1
        return 0

def is_str_stand_in (objItem):
    if type(objItem) == type(u' ') or type(objItem) == type(" "):
        return 1
    else:
        return 0

def seq2set (lst):
    seen = []
    for item in lst:
        if item not in seen:
            seen.append(item)
    return seen

def is_accept(obj):
    if the_type(obj) == 'Socket' and obj.operation == 'accept':
        return 1
    else:
        return 0

def process_name(pstr):
    #print pstr
    process = pstr.split('/')[-1]
    if pstr[0] == '.':
        return process
    else:
        #was return process + '@' + pstr
        return process

def config_namep (cstr):
    toreturn = 0
    if contains_str(cstr, PRGM.name_for_type):
        if contains_str(cstr, "etc/") \
            or contains_str(cstr, "conf"):
            toreturn = 1
    return toreturn
    

def config_name_maybep (cstr):
    if (contains_str(cstr, "etc/") and contains_str(cstr,PRGM.name_for_type)\
    or contains_str(cstr, "/.")): 
        return 1
    else:
        return 0
    
def remove_duplicates (lst):
    seen = []
    for item in lst:
        if item not in seen:
            seen.append(item)
    return seen

def the_type(obj):
    return obj.__class__.__name__

def print_connections (lst):
    for x in lst:
        print " "
        print "Name: " + x.name
        print '   from'
        for i in x.in_edges:
            print '    ' + i.domain.name
        print '   to'
        for i in x.out_edges:
            print '    ' + i.range.name

def similar (n1, n2):
    """ad hoc notion of similarity of names -
    want some reason to believe a file n1 is executed
    to produce process n2"""
    n1 = remove_exec(n1)
    n2 = remove_exec(n2)
    if contains_str(n1, n2) or contains_str(n2, n1):
        return True
    else:
        return False


def remove_exec (name):
    toreturn = name
    pos =  name.find('exec')
    if pos != -1:
        toreturn = name[:pos] + name[pos + 4:]
    return toreturn
    
def dtrace (to_print):
    if PRGM.debug == True:
        print 'Debug: ' + str(to_print)

def contains_str (source, target):
    """look in source for target"""
    return source.find(target) != -1
    
def singleton (lst):
    if len(lst) == 1:
        return 1
    else:
        return 0
