""" /**  Classes and Functions responsible for generating finder methods from giving recognizer
specifications.

     */"""

import sys
import re
import string
import config
from util import *
import patterns
import specs
import os.path

""" Players hold information on a pattern focus and its collaborators"""
class Player:
    def __init__(self, focus, role, nbr, pattern,\
                 justification = [], coll_structs = {}):
        self.focus = focus
        self.pattern_role = role
        self.recognizer = pattern
        self.nbr = nbr
        self.justification = justification
        self.with = coll_structs
    def __repr__(self):
        nm = self.pattern_role
        if nm == "obj":
            nm = self.recognizer.focus_name
        with_text = ""
        if not empty(self.with):
            with_text = " with ..."
        return "<" + self.focus.name + " is " + nm + with_text + ">"

def build_all ():
    """ Creates finder functions for all pattern_types"""
    for item in specs.SPECIFIERS:
        builder(item)
    return "Done"

def write_code (strm, nbr, str):
    """Writes 4 x nbr spaces followed by str."""
    #print spaces(nbr) + str
    strm.write(spaces(nbr) + str + "\n")

def builder (spec):
    """ This function opens a file in the pattern directory and
    creates the finder function for the spec type."""
    #file_name = os.path.dirname(config.__dict__['__file__']) + "/" + spec.__name__ + ".py"
    file_name = config.prgmPath +  "/" + spec.__name__ + ".py"
    strm = open(file_name, "w")
    genRecognitionString(strm, spec)
    strm.close

def genRecognitionString (strm, spec):
    """ Dispatches on 0 versus 1 or more collections for a pattern recognizer -
    called by builder"""
    #print("Working on " + spec.__name__ + "\n")
    #print strm
    if len(spec.collections) == 0:
        write_code(strm, 0,"\ndef finder(): []")
        get_current_program().pattern_instances[spec.__name__] = []
    else:
        process_objs(strm, spec)

def process_collaborator (strm, level, collaborator, specname, parentlabel):
    """ writes following text:
       subsystem_just = all_calls(obj)
       subsystem_items = next_classes_with_justifications(accessor, subsystem_just)"""
    label = collaborator.get_label()
    accessor = collaborator.get_accessor()
    ty = collaborator.get_recog_type()
    code = collaborator.get_code()
    justifications = label + "__just"
    items = label + "__items"
    stoppers = collaborator.stoppers
    #print stoppers
    write_code(strm, level, justifications + " = " + code)
    write_code(strm, level, "if empty(" + justifications + "):")
    write_code(strm, level + 1, "continue")
    write_code(strm, level, items + " = next_classes_with_justifications(" \
               + accessor + "," + justifications + ")")
    for s in stoppers:
        #print "writing a stopper"
        handle_stopper(strm, s, specname, level)
    if ty == "set":
        process_collection(strm, level, label, collaborator, items, specname, parentlabel)
    else:
        process_cascade (strm, level, collaborator, label, items,\
                         specname, parentlabel)

def process_collection (strm, level, label, collaborator, items, specname, parentlabel):
    """ e.g., subsystem = subsystem_items.keys()"""
    write_code(strm, level, label  + " = " + items + ".keys()")
    process_attachment(strm, level, label, parentlabel, specname)
    for n in collaborator.with:
        process_collaborator(strm, level + 1, n, specname, label)

def process_cascade (strm, level, collaborator, label, items, \
                     specname, parentlabel):
    """ e.g.,
    for client in client_items.keys():
            client_evidence = client_items[client]
            recursive call to process_collaborator"""
    player = label + "Player"
    write_code(strm, level, "for " + label + " in " + items + ".keys():")
    write_code(strm, level + 1, label + "__evidence = " + items + "[" + label + "]")
    write_code(strm, level + 1, player + \
               " = Player(" + label + ", '" + label + "', -1," + \
               specname + "," + label + "__evidence, {})")
    coll_names = [s.get_label() for s in collaborator.with]
    write_code(strm, level + 1, label + "_coll_names = " + str(coll_names))
    for n in collaborator.with:
        process_collaborator(strm, level + 1, n, specname, label)
    write_code(strm, level + 1, "if empty(setdiff(" + label + "_coll_names," + label + "Player.with.keys())):")
    write_code(strm, level + 2, "dict_put(" + parentlabel + "Player.with,'" + label + "'," + player + ")")

def process_attachment (strm, level, label, parentlabel, specname):
    """ writes the following sample text
        subsystem_aggr = make_aggr("subsystem", pattern, subsystem_items)
        objPlayer.with.append(subsystem_aggr)"""
    aggr = label + "__aggr"
    items = label + "__items"
    above = "dict_put(" + parentlabel + "Player.with,'" + label + "'," + aggr + ")"
    write_code(strm, level, aggr + " = make_aggr('" + label + "'," + specname + "," + items + ")")
    write_code(strm, level, above)

def top_text (strm, specname, search, inputs):
    """ generates the top of the finder file """
    write_code(strm, 0,"import config")
    write_code(strm, 0,"from util import *")
    write_code(strm, 0, "import sys")
    write_code(strm, 0,"from specs import * ")
    write_code(strm, 0,"from gen import Player ")
    write_code(strm, 0,"from futil import *\n\n")
    write_code(strm, 0,"def finder():")
    write_code(strm, 1, "print ''")
    write_code(strm, 1, "prgm = get_current_program()")
    write_code(strm, 1, "prgm.pattern_instances['" + specname + "'] = []")
    write_code(strm, 1, "nbr = 0")
    strm.writelines([("    " + c + "\n") for c in inputs])
    write_code(strm, 1, "for obj in " + search + ":")
    write_code(strm, 2, "sys.stdout.write('.')")
    write_code(strm, 2, "objPlayer = Player(obj, 'obj', 0," + specname + ", [], {})")

def handle_stopper (strm, itemStr, specname, level):
    """ generates code to write out why_not information"""
    write_code(strm, level, "if " + itemStr + ":") 
    write_code(strm, level + 1, "continue")


def process_objs (strm, specObj):
    """ Sends pattern_type specific lines of code to the strm"""
    specname = specObj.__name__
    coll = specObj.collections
    nbr_indent = 3
    if len(coll) > 1:
        nbr_indent = 2
    if len(coll) == 1 and coll[0].get_recog_type() == "set":
        nbr_indent = 2
    inputs = specObj.inputs
    search = specObj.search_set
    stoppers = specObj.stoppers
    top_text(strm, specname, search, inputs)
    coll_names = [s.get_label() for s in coll]
    write_code(strm, 2, "obj_coll_names = " + str(coll_names))
    for c in coll:
        process_collaborator(strm, 2, c, specname, "obj")
    for s in stoppers:
        handle_stopper(strm, s, specname, 2)
    for c in coll:
        local_var = c.get_label()
        ty = c.get_recog_type()
        strColl = "Player"
        if ty == "set": strColl = "__aggr"
    write_code(strm, 2, "#if collaborators, then add to found set")
    write_code(strm, 2, "if empty(setdiff(obj_coll_names, objPlayer.with.keys())):")
    write_code(strm, 3, "nbr = nbr + 1")
    write_code(strm, 3, "objPlayer.nbr = nbr")
    write_code(strm, 3, "prgm.pattern_instances['" + specname + "'].append(objPlayer)")
    write_code(strm, 1, "print nbr")
    #write_code(strm, 1, "whyNotStrm.close()")
    write_code(strm, 1, "return prgm.pattern_instances['" + specname + "']")

def get_collabs (specObj):
    """ returns the set of collaborator names for the pattern type """
    # get Recogs
    coll = specObj.collections
    #coll.reverse()
    below = [x.get_label() for x in  flatten([get_collabs_aux(s) for s in coll])]
    ans = [specObj.focus_name] + below
    return ans

def get_all_collabs ():
    # for debugging
    for pt in specs.SPECIFIERS:
        print pt
        print get_collabs(eval(pt))

def get_collabs_aux(recogObj):
    next = flatten([get_collabs_aux(s) for s in recogObj.with])
    return [recogObj] + next


