from util import *
from operators import *
import pr
import patterns
from specs import SPECIFIERS
from te_gen_util import get_type
import os.path
import config
from domain_model import setup_normalized_transitions
import presentations
import walk
from textentry import group_name_map, do_anomaly
from futil import reads_from, writes_to


""" Callbacks from GUI - includes the policy generation code"""

###################### Generator Classes ################################

class GenerationStrategy:

    def do_te_generation (self):
        self.open_file()
        """generates text, html files for regular and reference policy"""
        gen_te_page(self.file, TePR())
        self.open_html_file()
        gen_te_page(self.hfile, HtmlPR())
        gen_te_page(self.reference_policy_file, HtmlPR(), 0)
        self.hfile.close()
        self.reference_policy_file.close()
        
    def open_file (self):
        prgm = get_current_program()
        pname = prgm.name
        fileid  = pname + ".te"
        fileStr = config.result_file(fileid)
        out = open(fileStr, "w")
        print "Writing to " + fileStr
        self.file = out

    def open_html_file (self):
        prgm = get_current_program()
        pname = prgm.name
        fileid  = "te.html"
        fileStr = config.result_file(fileid)
        out = open(fileStr, "w")
        print "Writing to " + fileStr
        self.hfile = out
        reffileid  = "Ref-te.html"
        reffileStr = config.result_file(reffileid)
        refout = open(reffileStr, "w")
        print "Writing to " + reffileStr
        self.reffile = refout
        self.reference_policy_file = refout
    
    def close_file(self):
        #print 'closing file'
        self.file.close()
        
    def do_allows_and_macros (self, strm, test_for_coveragep):
        return "done"
    
class NoMacros (GenerationStrategy):
    
    def do_allows_and_macros(self, out, test_for_coveragep = 0): #current with test_for_coverage = 1
        #print normalized_transf.sc_from == 'typegen'
        seen = []
        out.write("\n\n##################### Allow Statements ##################### \n\n\n")
        populate_marks_on_transitions()
        for nt in normalized_trans.values():
            if nt.domain_context.find('polgen_temp') != -1 or nt.range_context.find('polgen_temp') != -1:
                # exists old keys - should not be here
                continue
            #current - only do next if not nt.is_covered()
            #see if there exists a pattern that reports this connection
            if not test_for_coveragep or not nt.is_covered():
                if nt.action != 'spawn':
                    if nt.action not in ['activate', 'exec']:
                        out.write(str(nt) + '\n')
                        out.write('#         because \n')
                        for e in nt.evidence_for:
                            out.write('#            ' + str(e) + '\n')



class WithMacros (GenerationStrategy):
    #obsolete
    def do_allows_and_macros(self, strm, test_for_coveragep): #this is current stategy
        the_no_macro_strategy.do_allows_and_macros(strm, 1)
        strm.write("##################### Pattern Instances #################### \n\n")
        instances = [pa for pa in pr.pattern_assertions_final.values() if pa.accepted == 1]
        for patstr in patterns.PATTERN_TYPES:
            print patstr
            current = [pa for pa in instances if pa.pattern.name == patstr]
            #print len(current)
            if len(current) != 0:
                for v in current:
                    realization = pr.all_pattern_realizations[v.evidence[0]]
                    print realization.contains_external()
                    
                    strm.write(realization.spec() + '\n')
                    #strm.write(v.print_form)
                    for e in v.evidence: #set of realizations:
                        strm.write('#          because of  ' + \
                                   str(pr.all_pattern_realizations[e].constellation[:-1]) + '\n')
                    strm.write(' \n')


class WithMacrosForSurvivorsOnly (GenerationStrategy):
    def do_allows_and_macros(self):
        return "done"

class TypingStrategy:
    def set_sc_for_objCB(self, f, value):
        """called via gui - value determined by user interaction"""
        TY_From_Contributors().go(f, value)


######################## Prototypes #######################################

TS = TypingStrategy()

gen_strategy = WithMacros()

the_no_macro_strategy = NoMacros()

###################### Handlers for html or text generation ###############

class PrintRequest:
    def __repr__ (self):
        return "print request"

class HtmlPR (PrintRequest):
    def __init__(self):
        self.linefeed = '<br>'
        self.start= '<h3>'
        self.end = '</h3>'
        self.focus = '<font color = "104bcl">'
        self.end_focus = '</font>'
        self.intro = '<html> \n'
        self.ending = '</html>'

class TePR (PrintRequest):
    def __init__(self):
        self.linefeed =  ''
        self.start= ''
        self.end = ''
        self.focus = ''
        self.end_focus = ''
        self.intro = ''
        self.ending = ''
        

##################### Callbacks #####################################

def adjust_pattern_list_finalCB ():
    """we look at active status of pattern realizations
    and adjust the type contributors
    At this point realizations should have their active property
    set (either by user or by default)"""
    for p in pr.all_pattern_realizations.values():
        patname = the_type(p)[:-1]
        contributor = patname.lower()
        patobj = eval('patterns.' + patname)
        participants = patobj.participants
        #first make sure any type modifications are removed if p is not active
        can_modify_type = patobj.gen_resource_types
        if can_modify_type != 'no':
            for part in participants:
                obj = p.__dict__[part] # the resource object
                if the_type(obj) == 'File' or \
                   (the_type(obj) == 'Process' and can_modify_type == part):
                    if p.active == 0 and contributor in obj.type_contributors:
                        obj.type_contributors.remove(contributor)
                        TY_Replace().go(obj, context2type(obj.original_context))
                    elif p.active == 1 and contributor not in obj.type_contributors:
                        obj.type_contributors.append(contributor)
      
                    
    




def set_integrity_groupCB(process_name, group):
    #print "setting " + process_name + " to group " + group
    resources_dict[process_name + ':Process'].group = group

def set_active_valueCB (item, value):
    v = 1
    if value == 'OFF':
        v = 0 # delete pattern instance
    TY_Adjust_Active().go(pr.pattern_assertions[item], v, "User choice")




def set_file_contextsCB (group, val):
       if val != 'ignore':
        processes = [p for p in resources_dict.values() if the_type(p) == 'Process' and \
                     p.group == group]
        files = []
        if val in ['ALL files read', 'ALL files read or modified']:
            for p in processes:
                #print p
                there = [t.domain for t in p.in_edges  \
                         if the_type(t.domain) == 'File']
                files = files + there
        elif val in ['ALL files modified', 'ALL files read or modified']:
            for p in processes:
                there = [t.range for t in p.out_edges \
                         if the_type(t.range) == 'File']
                files = files + there
        for f in seq2set(files):
            post(f, 'type_contributors', group)
            f.type_contributors.append(group)

def set_scCB (name, value, return_to_original = 0):
    #print "setting " + name + ' to ' + value
    f = resources_dict[name + ':File']
    TS.set_sc_for_objCB(f, value)

def set_dir_scCB (name, value):
    obj = resources_dict[name + ':File']
    post(obj, 'sc_extent', value)
    obj.sc_extent = value




##################### Policy Generators #########################
    



### typing rules
## original context could be set by environment or equal the polgen default
## if the polgen default then it is possible that the type could be changed thru participation in a pattern
##      the new type would be <prgm-name>_<pattern-type>_t
## or thru belonging to a group
##      the new type would be <prgm-name>-<group-name>_t
## environment types are not reset by polgen -
##    that is, we only want to change types for those files that are "owned" by the application
##    if we changed a type from 1_t to 2_t, then every other application that used to communicate
##    with 1_t would now also need to communicate with 2_t - should we allow the policy writer to do this?
### let's say we allow the policy writer to change what he/she wants based on information that polgen provides.
##     two situations
##  1. patterns - writer is notified that if an environmental resource is treated as special there would be a pattern
##  2. groups of read or modified - default is to bring up the original environment set type.  If policy writer chooses
##    to override the default, we pop up a message - " are you sure you want to do this"
##


        
##################### Fc Generation ###############################

def get_dir_extension_to_use (name, extension):
    dir = os.path.dirname(name)
    file_name = name.split('/')[-1].split('.')
    possible_name = ""
    if extension == 'dir/name':
        use = name
    elif len(file_name) > 1:
        possible_name = file_name[0]
        if extension == 'dir/name.*':
            use = dir + '/' + possible_name + '.*'
        else:
            use = dir + extension[3:]
    else: # no . in string
        if extension == 'dir/name.*':
            use = name + '.*'
        else:
            use = dir + extension[3:]
    return use

def do_fc_generation(name_extension_pairs):
    prgm = get_current_program()
    pname = prgm.name
    fileid  = pname + ".fc"
    fileid_reg = 'fc.html'
    fileid_ref = 'Ref-fc.html'
    do_fc_generation_aux(pname, fileid, name_extension_pairs, TePR())
    do_fc_generation_aux(pname, fileid_reg, name_extension_pairs, HtmlPR())
    do_fc_generation_aux(pname, fileid_ref, name_extension_pairs, HtmlPR())
    
def do_fc_generation_aux(prgm_name, fileid, name_extension_pairs, printreq):
    fileStr = config.result_file(fileid)
    fc_strm = open(fileStr, "w")
    print "Writing to " + fileStr
    linefeed = printreq.linefeed
    start= printreq.start
    end = printreq.end
    focus = printreq.focus
    end_focus = printreq.end_focus
    intro = printreq.intro
    ending = printreq.ending
    fc_strm.write(intro)
    responses = []
    for item in name_extension_pairs:
        name = item[0]
        obj = resources_dict[name + ':File']
        context = obj.get_sc()
        extension = item[1]
        use = get_dir_extension_to_use(name, extension)
        responses.append([use, context])
    responses = seq2set(responses)
    max = 0
    for  r in responses:
        if len(r[0]) > max:
            max = len(r[0])
    for r in responses:
        fname = r[0]
        context = r[1]
        there = len(fname)
        spaces = max - there + 40
        fc_strm.write("%s %s %*s \n" % (linefeed, fname, spaces, context))
    fc_strm.close()

################## Te Generation Strategies ########################
    


def populate_marks_on_transitions():
    for realization in [x for x in pr.all_pattern_realizations.values() if x.active == 1]:
        parts = realization.participants
        walk_participants(realization, parts)

def walk_participants (realization, remainder):
    """ remainder is a list of participants """
    if len(remainder) > 1:
        r1 = remainder[0]
        r2 = remainder[1]
        if r2 in trans[r1].keys():
            trans[r1][r2].marked.append(realization)
        elif r1 in trans[r2].keys():
            trans[r2][r1].marked.append(realization)
        walk_participants(realization, remainder[1:])

def gen_te_page (out, printreq, do_all_allows = 1):
    """out is strm, printreq dispatch on text vs. html,
    do_all_allows is flag for regular vs. reference policy (this needs work)"""
    linefeed = printreq.linefeed
    start= printreq.start
    end = printreq.end
    focus = printreq.focus
    end_focus = printreq.end_focus
    intro = printreq.intro
    ending = printreq.ending
    out.write(intro)
    out.write(start + "##################### Type Declarations ####################" \
              + end + " \n\n")
    use = []
    found = {}
    for r in resources_dict.values():
        orig = r.original_context
        now = r.get_sc()
        if now == None:
            print "security context not set for" + r
        if orig != now and now.find(PRGM.name_for_type) != -1:
            if now in found.keys():
                found[now].append(r)
            else:
                found[now] = [r]
    for sc in found.keys():
        types = {}
        for support in found[sc]:
            ty = the_type(support).lower()
            if support.special_name != None:
                ty = support.special_name
            if ty in types.keys():
                types[ty].append(support)
            else:
                types[ty] = [support]
        for t in types.keys():
            if t == 'spawn':
                continue
            elif t in ['file', 'dir']:
                if sc.find('exec_t') != -1:
                    attribute = 'file_type, exec_type'
                else:
                    attribute = 'file_type, sysadmfile'
            elif t == 'process':
                attribute = 'domain'
            else:
                attribute = t

            use.append('type ' + context2type(str(sc)) + ',' \
                                  + attribute + '; \n\n')
    use = seq2set(use)
    for item in use:
        out.write(linefeed + focus + item + end_focus + ' \n')
    out.write(start + "##################### Allow Statements ####################" + end + "\n\n")
    for nt in normalized_trans.values():
        if nt.domain_context.find('polgen_temp') != -1 \
           or nt.range_context.find('polgen_temp') != -1:
                # exists old keys - should not be here
                continue
        #see if there exists a pattern that reports this connection
        if not nt.is_covered():
            if nt.action not in ['spawn','activate', 'exec']:
                 ok = 1
                 if not do_all_allows: # need to check for external references
                    dom = nt.domain_context
                    ran = nt.range_context
                    if dom.find(PRGM.name_for_type) == -1 \
                       or ran.find(PRGM.name_for_type) == -1:
                         ok = 0                
                 if ok:
                    out.write(focus + linefeed + str(nt) + end_focus + ' \n')
                    out.write(linefeed + '#--------------because \n')
                    for e in nt.evidence_for:
                        out.write(linefeed + '#-----------------' + str(e.name) + '\n')
    out.write(start + "##################### Pattern Instances ####################" + end + "\n\n")
    instances = [pa for pa in pr.pattern_assertions_final.values() if pa.accepted == 1]
    for patstr in patterns.PATTERN_TYPES:
        current = [pa for pa in instances if pa.pattern.name == patstr]
        if len(current) != 0:
            for v in current:
                realization = pr.all_pattern_realizations[v.evidence[0]]
                if realization.contains_external():
                        get_current_program().external_connections.append(realization.spec())
                out.write(linefeed + focus + realization.spec() \
                           + end_focus + '\n')
                #strm.write(v.print_form)
                for e in v.evidence: #set of realizations:
                        out.write(linefeed + '#--------------------' + \
                                  str([x.name for x in pr.all_pattern_realizations[e].constellation[:-1]]) + '\n')
                out.write(' \n')
    out.write(ending)



def clean_up ():
    for r in resources_dict.values():
        new_sc = temp_type_replacement(r)
        if new_sc!= r.get_sc():
            TY_Replace().go(r, context2type(new_sc))
        domain = PRGM.unconfined_domain
        if domain != 'unconfined_t':
            #need to change all unconfined_t
            pos = context2type(new_sc).find('unconfined_t')
            if pos != -1:
                TY_Replace().go(r, domain, 'setting unconfined_domain')
            
    setup_normalized_transitions(1) # re-do with new types


        
def do_policy_generationCB():
    items = [f for f in resources_dict.values() if the_type(f) == 'File']
    data = [[f.name, f.sc_extent] for f in items if \
            f.original_context != f.get_sc() \
            or f.sc_from == 'typegen']
            #f.original_context != f.get_sc()]
    clean_up()
    redo_pattern_assertions()
    problems = multiple_transitions()
    if len(problems) > 0:
        do_anomaly()
        print "\nRepairing multiple transition anomalies"
        #print problems.keys()
        for k in problems.keys():
            TY_Repair_Multiple_Trans().go(problems[k])
        print '\n'

    do_fc_generation(data) 
    gen_strategy.do_te_generation()

def redo_pattern_assertions():
    for preal in pr.all_pattern_realizations.values():
        #print preal
        pr.pattern_assertion_final_factory(preal)


def multiple_transitions ():
    execs = [x for x in pr.all_pattern_realizations.values() \
             if x.pattern.name == 'Executable']
    seen = {}
    for e in execs:
        types = str([context2type(x.get_sc()) for x in e.participants][:-1])
        if types not in seen.keys():
            seen[types] = [e]
        else:
            seen[types].append(e)
    problems = {}
    for k in seen.keys():
        there = seen[k]
        #problem if they don't all have the same third type
        third = seq2set([context2type(x.participants[2].get_sc()) \
                         for x in there])
        if len(third) > 1:
            problems[k + "->" + str(third)] = there
    for k in problems.keys():
        print k
    return problems
