#!/usr/bin/env python


""" Handlers for file context interactions """

from util import *
if not PRGM.no_gui:
	import pygtk
	pygtk.require('2.0')
	import gtk
        import gobject
import fixer

MAX_WINDOW_Y_SIZE=650

def files_for_checking (files):
    files2check = []
    for f in files:
        tcs = f.type_contributors
        if len(tcs) > 1:
            tcs = ['all'] + tcs
        if f.sc_from == 'typegen':
            files2check.append([f.uid, f.name, tcs + [f.original_context], 1])
        elif PRGM.outsiders_mutable and PRGM.unlimited_typing:
            files2check.append([f.uid, f.name, [f.original_context] + tcs, 0])
    return files2check

# Convenience functions

def make_menu_item(name, callback, data=None):
    item = gtk.MenuItem(name)
    item.connect("activate", callback, data)
    item.show()
    return item

class SetFileContext:

    def done (self, the_done_button = None):
        count = 0
        for f in self.files2check:
            item = self.choices[f[0]]
            pos = item.get_active()
            fixer.set_scCB(f[1], item.items[pos] , 1)
        self.window.destroy()
        files = [f for f in resources_dict.values() \
                 if f.__class__.__name__ == 'File']
        files_from_envir = [f for f in files if f.sc_from != 'typegen' \
                            and f.security_context != f.original_context]

        files2check = files_for_checking(files_from_envir)
        if len(files2check) != 0:
            Confirm("Confirm or Retract Type: These files may be accessed outside of this application.", \
                    files2check)
        else:
            end_session(self)

    def __init__(self, title, files2check):
        self.init_gui(title, files2check)
    def init_gui(self, title, files2check):
        self.window = gtk.Dialog() 
        self.window.set_title(title)
	ysz = 1200
        nbr = len(files2check)
        if nbr < 10:
            ysz = (80 * nbr) + 60
        self.window.set_size_request(400, min(MAX_WINDOW_Y_SIZE,ysz))
	

        scrolled_window = gtk.ScrolledWindow()
	scrolled_window.set_border_width(10)
	scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)

	self.window.vbox.pack_start(scrolled_window, 1, 1, 0)
	scrolled_window.show()

        self.choices = {}
        self.files2check = files2check
        box1 = gtk.VBox(0, 0)
        scrolled_window.add_with_viewport(box1)
        box1.modify_bg(gtk.STATE_NORMAL, gtk.gdk.Color(60000, 60000, 30000))
        
        box1.show()

        for f in files2check:
            # An option menu to select directory context
            box2 = gtk.HBox(0, 10)
            box2.set_border_width(10)
            label = gtk.Label(f[1])
            box2.pack_start(label, 0, 0, 0)
            label.show()
            opt = gtk.combo_box_new_text()
            self.choices[f[0]] = opt
            options = f[2]
            typegen_marker = f[3]
            count = 1
            opt.items = options
            opt.reverse_labels = {}
            len_options = len(options)
            for choice in options:
                if count == 1 and typegen_marker == 0: #original at front
                    ppchoice = choice + ' (no change)'
                elif count == len_options and typegen_marker == 1: # original at end
                    ppchoice = choice
                else:
                    ppchoice = fixer.get_stype_from_contributor(choice)
                opt.reverse_labels[ppchoice] = choice
                opt.insert_text(count, ppchoice)
                opt.set_active(0)
                count = count + 1
            box2.pack_start(opt, 1, 1, 0)
            opt.show()

            box1.pack_start(box2, 1, 1, 0)
            box2.show()

        box2 = gtk.HBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        button = gtk.Button("Done")
        button.connect("clicked", self.done)
        box2.pack_start(button, 0, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()
        self.window.show()

class Confirm (SetFileContext):
     def done (self, the_done_button = None):
        count = 0
        for f in self.files2check:
            item = self.choices[f[0]]
            pos = item.get_active()
            fixer.set_scCB(f[1], f[2][pos], 1)
        self.window.destroy()
        files = [f for f in resources_dict.values() if f.__class__.__name__ == 'File' and \
                          not f.is_local() and len(f.type_contributors) != 0]
        if len(files) != 0:
             SetDirectoryContext(files)
        else:
            end_session(self)
    

def end_session (win):
    fixer.do_policy_generationCB()
    win.window.destroy()
    gtk.main_quit()
        
class SetDirectoryContext:

    def done (self, the_done_button = None):
        count = 0
        for f in self.files:
            item = self.choices[f.name]
            fixer.set_dir_scCB(f.name, self.options[item.get_active()])
        end_session(self)


    def cb_menu_select(self, item, uid):
        fixer.set_fc(uid, str(1))

    def __init__(self, files):
         self.init_gui(files)
    def init_gui(self, files):
        self.window = gtk.Dialog() 
        self.window.set_title("Set .fc Directory Specifications")
	self.window.set_border_width(0)
	ysz = 300
        nbr = len(files)
        if nbr < 10:
            ysz = 120 * nbr
        self.window.set_size_request(400, min(MAX_WINDOW_Y_SIZE,ysz))


        scrolled_window = gtk.ScrolledWindow()
	scrolled_window.set_border_width(10)
	scrolled_window.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_ALWAYS)

	self.window.vbox.pack_start(scrolled_window, 1, 1, 0)
	scrolled_window.show()

        self.choices = {}
        self.files= files
        box1 = gtk.VBox(0, 0)

        scrolled_window.add_with_viewport(box1)      
        self.options = ['dir/name.*', 'dir/name', 'dir(/.*)?', 'dir/', 'dir/.*']
        box1.show()

        box2 = gtk.HBox(0, 10)
        self.box2 = box2
        box2.set_border_width(10)
        box1.pack_start(box2, 1, 1, 0)
        box2.show()

        self.files = files
        for f in self.files:
            # An option menu to select directory context
            box2 = gtk.HBox(0, 10)
            box2.set_border_width(10)
            label = gtk.Label(f.name)
            box2.pack_start(label, 0, 0, 0)
            label.show()
            opt = gtk.combo_box_new_text()
            self.choices[f.name] = opt

            count = 1
            for choice in self.options:
                opt.insert_text(count, choice)
                opt.set_active(0)
                count = count + 1
            box2.pack_start(opt, 1, 1, 0)
            opt.show()

            box1.pack_start(box2, 1, 1, 0)
            box2.show()
        box2 = gtk.HBox(0, 10)
        box2.set_border_width(10)
        box1.pack_start(box2, 0, 1, 0)
        box2.show()

        button = gtk.Button("Finish (generate te and fc files)")
        button.connect("clicked", self.done)
        box2.pack_start(button, 1, 1, 0)
        button.set_flags(gtk.CAN_DEFAULT)
        button.grab_default()
        button.show()
        self.window.show()

def main():
    global no_gui
    if not no_gui: gtk.main()
    return 0

if __name__ == "__main__":
    Confirm('Test', [])
    main()
