# --------------------------------------------------------------------------- #
# $Id: unicode.py,v 1.5 2004/01/08 22:11:12 pandr Exp $
# --------------------------------------------------------------------------- #
#

from pllshared import *
import os
import re
import pllmodules 

pll = None

def register():
	pll.add_command("greek_unicode", _greekunicode, empty = 1)

def _greekunicode(args, parser):
	greek_chart = {
		'alpha':0x03B1,
		'beta':0x03B2,
		'gamma':0x03B3,
		'delta':0x03B4,
		'epsilon':0x03B5,
		'zeta':0x03B6,
		'eta':0x03B7,
		'theta':0x03B8,
		'iota':0x03B9,
		'kappa':0x03BA,
		'lambda':0x03BB,
		'mu':0x03BC,
		'nu':0x03BD,
		'xi':0x03BE,
		'o':0x03BF,
		'pi':0x03C0,
		'rho':0x03C1,
		'sigma':0x03C3,
		'tau':0x03C4,
		'upsilon':0x03C5,
		'phi':0x03C6,
		'chi':0x03C7,
		'psi':0x03C8,
		'omega':0x03C9
	}
	for name,unicode in greek_chart.items():
		pll.add_command(
			name,
			eval('lambda args, t: [pll.letter(%i)]' % unicode),
			empty = 1
		)
	return []

# --------------------------------------------------------------------------- #

