# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import ForwardingFolder, Log

class SortedFolder(ForwardingFolder.ForwardingFolder):

	def __init__(self, folder, func):
		Log.log("initializing SortedFolder", folder, func)
		ForwardingFolder.ForwardingFolder.__init__(self)
		self._folder = folder
		self.func = func
		self.name = 'sort('+self._folder.name+')'

	def _get_messages(self):
		Log.log("getting messages")
		messages = []
		for mes in self._folder.messages:
			Log.log("schwartzing", mes)
			schwartz = self.func(self._folder, mes)
			messages.append((schwartz, mes))
		messages.sort()
		ret= []
		for (schwartz, mes) in messages:
			Log.log("unschwartzing", schwartz, mes)
			ret.append(mes)
		return ret

	def folder(self, folder):
		Log.log("getting subfolder", folder)
		return SortedFolder(self._folder.folder(folder), self.func)
