# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pmh@zadka.site.co.il>
import Configuration, LimitFolder, LimitFunctions, Log
import re
from cStringIO import StringIO

class ReSearcher:

	def __init__(self, re):
		self.re = re

	def __call__(self, *args):
		return apply(self.re.search, args)

def limit_header(header, content=None):
	Log.log("limiting", header, "to", content)
	status = Configuration.Configuration().status
	folder = status.get_folder()
	if content is None:
		Log.log("content is None, guessing...")
		message = folder.get_header()
		content = '^'+re.escape(message.get(header, ''))+'$'
		Log.log("content is ", content)
	content = ReSearcher(re.compile(content))
	Log.log("created researcher")
	function = LimitFunctions.HeaderMatches(header, content)
	limit = LimitFolder.LimitFolder(folder, function)
	Log.log("got folder")
	status.push_folder(limit)
	Log.log("pushed folder")

def limit_from(name=None):
	'''\
	limit_from([name])

	Limit to messages from [name]. Default is sender of the
	current message.
	'''
	Log.log("limiting to message originating from", name)
	limit_header('from', name)

def limit_subject(subject=None):
	'''\
	limit_subject([subject])

	Limit to messages with given subject. Default is the subject
	of the current message.
	'''
	Log.log("limiting to message with the subject", subject)
	limit_header('subject', subject)

def limit_label(label=None):
	'''\
	limit_label([label])

	Limit to messages with given label. Default is the label
	of the current message.
	'''
	Log.log("limiting to message with label", label)
	limit_header('x-pms-label', label)

def limit_replies():
	'''\
	limit_replies()

	Limit to replies of the current message.
	'''
	Log.log("limiting to replies of current message")
	status = Configuration.Configuration().status
	folder = status.get_folder()
	message = folder.get_header()
	Log.log("replies to", `message['message-id']`)
	id = ReSearcher(re.compile(re.escape(message['message-id'])))
	first_function = LimitFunctions.HeaderMatches("in-reply-to", id)
	second_function = LimitFunctions.HeaderMatches("references", id)
	function = LimitFunctions.Or(first_function, second_function)
	limit = LimitFolder.LimitFolder(folder, function)
	Log.log("created folder")
	status.push_folder(limit)
	Log.log("pushed folder")
