# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Runner, Actions, Configuration, MailMessage
import rfc822, string
from cStringIO import StringIO

address_headers = ('to', 'cc', 'bcc')

def translate_aliases(aliases, message):
	for header in address_headers:
		if not message.has_key(header):
			continue
		addresses = rfc822.AddrlistClass(message[header]).getaddrlist()
		for i in range(len(addresses)):
			addresses[i] = get_address(aliases, addresses[i])
		if not addresses:
			continue
		message[header] = string.join(addresses, ', ')

def get_address(aliases, address):
	if address[0] != '' or not aliases.has_key(address[1]):
		return rfc822.dump_address_pair(address)
	return aliases[address[1]]

def translate_message_aliases(runner, _, uid, **kw):
	aliases = Configuration.Configuration().aliases
	s = Actions.get_draft(uid)
	body = StringIO(s.fp.read())
	s.fp = body
	translate_aliases(aliases, s)
	Actions.save_draft(s, uid)
			
Runner.Runner().register_posthook('edit_draft', translate_message_aliases)
