#!/usr/bin/python2.1
import os, string, re, BaseHTTPServer, posixpath, dircache

class EOFError(Exception):
	pass

def netstring(s):
	return '%s:%s' % (len(s), s)

def choose_message(path):
	subs = filter(MailHTTPRequestHandler.int, os.listdir(path))
	if not subs: 
		return os.path.join(path, '1')
	else:
		subs = map(int, subs)
		subs.sort()
		return os.path.join(path, str(subs[-1]+1))

class MailHTTPRequestHandler(BaseHTTPServer.BaseHTTPRequestHandler):

	int = re.compile("[0-9]*$").match

	def authenticate(self):
		if self.headers['x-secret'] != self.secret:
			raise ValueError("user is not authenticated")

	def send_response(self, code, message):
		self.log_request(code)
		self.wfile.write("%s %s %s\r\n" %
		                 (self.protocol_version, code, message))

	def copyfile(self, from_, to):
		while 1:
			s = from_.read(8192)
			if not s:
				break
			to.write(s)

	def send_response(self, code, message):
		self.log_request(code)
		message = self.responses.get(code, [''])[0]
		self.wfile.write("%s %s %s\n" % 
		                 (self.protocol_version, code, message))

	def do_GET(self):
		self.authenticate()
		if self.path[-1] == '/':
			self.get_folder()
		else:
			self.get_message()

	def do_HEAD(self):
		self.authenticate()
		path = self.translate_path()
		try:
			fp = open(path)
		except (IOError, OSError):
			self.send_error(404, "Not a valid message")
			return
		while 1:
			line = fp.readline()
			if len(line) <= 1:
				break
			self.wfile.write(line)

	def do_MKCOL(self):
		self.authenticate()
		path = self.translate_path()
		try:
			os.makedirs(path)
		except (IOError, OSError):
			self.send_error(403, "Could not create folder")
		self.send_response(201, "Created folder")
		self.end_headers()

	def do_PUT(self):
		self.authenticate()
		path = self.translate_path()
		if self.path[-1] == '/':
			try:
				path = choose_message(path)
			except (IOError, OSError), exc:
				print 'choose', exc
				self.send_error(404, "Not a valid message")
		try:
			fp = open(path, 'w')
		except (IOError, OSError), exc:
			print 'open', exc
			self.send_error(404, "Not a valid message")
			return
		for (header, value) in self.headers.items():
			if header == 'x-secret':
				continue
			fp.write("%s: %s\n" % (header, value))
		fp.write("\n")
		to_do = int(self.headers['content-length'])
		while to_do>0:
			buf = self.rfile.read(min(8192, to_do))
			to_do = to_do - len(buf)
			fp.write(buf)
		fp.close()
		self.send_response(201, "Created Message")
		created = self.path
		if self.path[-1] == '/':
			created = os.path.join(created, os.path.basename(path))
		self.send_header('Location', created)
		self.end_headers()

	def do_DELETE(self):
		self.authenticate()
		path = self.translate_path()
		dir, file = os.path.split(path)
		new_file = ','+file
		try:
			os.rename(path, os.path.join(dir, new_file))
		except OSError:
			self.send_error(403, "Can not delete message")
		else:
			self.send_response(206, "Deleted message")
			self.end_headers()

	def get_folder(self):
		self.authenticate()
		path = self.translate_path()
		try:
			subs = os.listdir(path)
		except (IOError, OSError):
			self.send_error(404, "Not a folder")
			return
		dircache.annotate(path, subs)
		self.send_response(300, "Folder Contents")
		self.send_header("Content-Type", "text/x-netstrs")
		self.end_headers()
		for s in subs:
			if s[-1]=='/' or self.int(s):
				self.wfile.write(netstring(s))

	def get_message(self):
		self.authenticate()
		path = self.translate_path()
		try:
			fp = open(path)
		except (IOError, OSError):
			self.send_error(404, "Not a valid message")
			return
		self.send_response(200, "Raw Message")
		self.copyfile(fp, self.wfile)

	def translate_path(self):
		self.authenticate()
		path = posixpath.normpath(self.path)
		words = string.split(path, '/')
		words = filter(None, words)
		path = os.getcwd()
		for word in words:
			drive, word = os.path.splitdrive(word)
			head, word = os.path.split(word)
			if word in (os.curdir, os.pardir): continue
			path = os.path.join(path, word)
		return path

def generate_secret():
	import base64
	random = open("/dev/random")
	secret_file = os.path.join(os.environ['HOME'], '.secret')
	fp = open(secret_file, 'w')
	fp.close()
	os.chmod(secret_file, 0700)
	fp = open(secret_file, 'w')
	secret = string.join(string.split(base64.encodestring(random.read(128))), '')
	fp.write(secret)
	fp.close()
	random.close()
	MailHTTPRequestHandler.secret = secret

def test():
	import SocketServer
	generate_secret()
	BaseHTTPServer.test(HandlerClass=MailHTTPRequestHandler)

if __name__ == '__main__':
	test()
