/*
 * $Id: screen.c,v 1.20 2001/09/16 15:07:38 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "debug.h"
#include "mainform.h"
#include "os.h"
#include "prefsdata.h"
#include "resourceids.h"
#include "screen.h"


/***********************************************************************
 *
 *      Private variables
 *
 ***********************************************************************/
static UInt32 screenDepth = 1;



/* Set screen bit depth for PalmOS3 */
void SetScreenModeOS3( void )
{
    Err     err;
    UInt16  activeFormID;

    if ( screenDepth == Prefs()->screenDepth )
        return;

    screenDepth = Prefs()->screenDepth;

    err = WinScreenMode( winScreenModeSet, NULL, NULL, &screenDepth, NULL );
    if ( err != errNone ) {
        WinScreenMode( winScreenModeGetDefaults, NULL, NULL, &screenDepth, NULL );
        Prefs()->screenDepth = screenDepth;
        WinScreenMode( winScreenModeSetToDefaults, NULL, NULL, NULL, NULL );
    }
    activeFormID = FrmGetActiveFormID();
    if ( activeFormID == frmMainTop || activeFormID == frmMainBottom ) {
        FrmEraseForm( FrmGetFormPtr( activeFormID ) );
        MainFormInit();
    }
}



/* Set screen bit depth for PalmOS2 */
void SetScreenModeOS2( void )
{
    SetDefaultScreenModeOS2( true );
}



/* Restore screen mode ( PalmOS 3.x ) */
void SetDefaultScreenModeOS3
    (
    Boolean save    /* store screen depth */
    )
{
    WinScreenMode( winScreenModeGetDefaults, NULL, NULL, &screenDepth, NULL );
    WinScreenMode( winScreenModeSetToDefaults, NULL, NULL, NULL, NULL );
    if ( save )
        Prefs()->screenDepth = screenDepth;
}



/* Restore screen mode ( PalmOS 2.x ) */
void SetDefaultScreenModeOS2
    (
    Boolean save    /* store screen depth */
    )
{
    screenDepth             = 1;
    Prefs()->screenDepth    = screenDepth;
}



/* Check if the current device can handle the bit depth of the image ( OS 3.5/4.x version ) */
Boolean TooHighBitDepth_Max
    (
    UInt32 depth    /* bit depth */
    )
{
    return ( GetMaxScreenDepth() < depth );
}



/* Check if the current device can handle the bit depth of the image ( default version ) */
Boolean TooHighBitDepth_Default
    (
    UInt32 depth    /* bit depth */
    )
{
    return ( screenDepth < depth );
}
