#lang scribble/doc
@(require scribble/manual
          (for-label scheme/base
                     scheme/class
                     scheme/unit)
          "common.ss")

@title[#:tag "zo"]{Compiling to Raw Bytecode}

The @DFlag{zo}/@Flag{z} mode for @|mzc| is an improverished form of
the default @DFlag{make}/@Flag{k} mode (which is described in
@secref["make"]), because it does not track import dependencies. It
does, however, support compilation of non-module source.

By default, the generated bytecode is placed in the same directory as
the source file---which is not where it will be found automatically
when loading the source. Use the @as-index{@DFlag{auto-dir}} flag to
redirect the output to a @filepath{compiled} subdirectory, where it
will be found automatically when loading the source file.

Outside of a module, top-level @scheme[define-syntaxes],
@scheme[module], @scheme[#%require],
@scheme[define-values-for-syntaxes], and and @scheme[begin]
expressions are handled specially by @exec{mzc --zo}: the compile-time
portion of the expression is evaluated, because it might affect later
expressions. (The @Flag{m} or @DFlag{module} flag turns off this
special handling.)

For example, when compiling the file containing

@schemeblock[
(require scheme/class)
(define f (class% object% (super-new)))
]

the @scheme[class] form from the @schememodname[scheme/class] library
must be bound in the compilation namespace at compile time. Thus, the
@scheme[require] expression is both compiled (to appear in the output
code) and evaluated (for further computation).

Many definition forms expand to @scheme[define-syntaxes]. For example,
@scheme[define-signature] expands to @scheme[define-syntaxes]. In
@scheme[--zo] mode, @|mzc| detects @scheme[define-syntaxes] and other
expressions after expansion, so top-level @scheme[define-signature]
expressions affect the compilation of later expressions, as a
programmer would expect.

In contrast, a @scheme[load] or @scheme[eval] expression in a source
file is compiled---but @emph{not evaluated!}---as the source file is
compiled.  Even if the @scheme[load] expression loads syntax or
signature definitions, these will not be loaded as the file is
compiled. The same is true of application expressions that affect the
reader, such as @scheme[(read-case-sensitive #t)]. The @Flag{p} or
@DFlag{prefix} flag for @|mzc| takes a file and loads it before
compiling the source files specified on the command line.

In general, a better solution is to put all code to compile into a
module and use @|mzc| in its default mode.
