/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  mult8.c:  emulation of 8-bit multiplication instructions
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */


#include "plex86.h"
#include "monitor.h"


  void
MUL_ALEb(vm_t *vm)
{
  Bit8s  op2, op1;
  Bit16s product_16;
  Bit32u eflags, arithmetic_eflags;
 
  op1 = G_AL(vm);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  arithmetic_eflags = read_eflags(vm) & 0x000008d5;
  eflags = 0; /* keep compiler quiet */
 
  asm volatile (
    /* First copy guest arithmetic flags to monitor flags */
    "pushfl                \n\t" /* Get mon flags */
    "popl   %0             \n\t"
    "andl  $0xfffff700, %0 \n\t" /* Erase mon arithmetic flags */
    "orl   %5, %0          \n\t" /* Or in guest arithmetic flags */
    "pushl %0              \n\t" /* Set flags in mon */
    "popfl                 \n\t"
    "mulb %4               \n\t"
    "pushfl                \n\t"
    "popl   %0"
    : "=r" (eflags), "=a" (product_16)
    : "0" (eflags), "1" (op1), "mq" (op2), "g" (arithmetic_eflags)
    : "memory", "cc"
    );
 
  G_AX(vm) = product_16;
  SetOSZAPC(vm, eflags);
}

  void
IMUL_ALEb(vm_t *vm)
{
  Bit8s  op2, op1;
  Bit16s product_16;
  Bit32u eflags, arithmetic_eflags;
 
  op1 = G_AL(vm);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  arithmetic_eflags = read_eflags(vm) & 0x000008d5;
  eflags = 0; /* keep compiler quiet */
 
  asm volatile (
    /* First copy guest arithmetic flags to monitor flags */
    "pushfl                \n\t" /* Get mon flags */
    "popl   %0             \n\t"
    "andl  $0xfffff700, %0 \n\t" /* Erase mon arithmetic flags */
    "orl   %5, %0          \n\t" /* Or in guest arithmetic flags */
    "pushl %0              \n\t" /* Set flags in mon */
    "popfl                 \n\t"
    "imulb %4              \n\t"
    "pushfl                \n\t"
    "popl   %0"
    : "=r" (eflags), "=a" (product_16)
    : "0" (eflags), "1" (op1), "mq" (op2), "g" (arithmetic_eflags)
    : "memory", "cc"
    );
 
  G_AX(vm) = product_16;
  SetOSZAPC(vm, eflags);
}

  void
DIV_ALEb(vm_t *vm)
{
  Bit8u  op2;
  Bit16u ax;
  Bit32u eflags, arithmetic_eflags;
 
  ax = G_AX(vm);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  if (op2 == 0) {
    exception(vm, ExceptionDE, 0);
    }

  arithmetic_eflags = read_eflags(vm) & 0x000008d5;
  eflags = 0; /* keep compiler quiet */
 
  asm volatile (
    /* First copy guest arithmetic flags to monitor flags */
    "pushfl                \n\t" /* Get mon flags */
    "popl   %0             \n\t"
    "andl  $0xfffff700, %0 \n\t" /* Erase mon arithmetic flags */
    "orl   %5, %0          \n\t" /* Or in guest arithmetic flags */
    "pushl %0              \n\t" /* Set flags in mon */
    "popfl                 \n\t"
    "divb  %4              \n\t"
    "pushfl                \n\t"
    "popl   %0"
    : "=r" (eflags), "=a" (ax)
    : "0" (eflags), "1" (ax), "mq" (op2), "g" (arithmetic_eflags)
    : "memory", "cc"
    );


  G_AX(vm) = ax;
  SetOSZAPC(vm, eflags);
}

  void
IDIV_ALEb(vm_t *vm)
{
  Bit8u  op2;
  Bit16u ax;
  Bit32u eflags, arithmetic_eflags;
 
  ax = G_AX(vm);
 
  if (vm->i.mod == 0xc0) {
    op2 = ReadReg8(vm, vm->i.rm);
    }
  else {
    read_virtual_byte(vm, vm->i.seg, vm->i.rm_addr, &op2);
    }
 
  if (op2 == 0) {
    exception(vm, ExceptionDE, 0);
    }

  arithmetic_eflags = read_eflags(vm) & 0x000008d5;
  eflags = 0; /* keep compiler quiet */
 
  asm volatile (
    /* First copy guest arithmetic flags to monitor flags */
    "pushfl                \n\t" /* Get mon flags */
    "popl   %0             \n\t"
    "andl  $0xfffff700, %0 \n\t" /* Erase mon arithmetic flags */
    "orl   %5, %0          \n\t" /* Or in guest arithmetic flags */
    "pushl %0              \n\t" /* Set flags in mon */
    "popfl                 \n\t"
    "idivb  %4             \n\t"
    "pushfl                \n\t"
    "popl   %0"
    : "=r" (eflags), "=a" (ax)
    : "0" (eflags), "1" (ax), "mq" (op2), "g" (arithmetic_eflags)
    : "memory", "cc"
    );


  G_AX(vm) = ax;
  SetOSZAPC(vm, eflags);
}
