/*
    Bear Engine - Level editor

    Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

    This program is free software; you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by the
    Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This program is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
    more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    contact: plee-the-bear@gamned.org

    Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file bf/code/level_editor.cpp"
 * \brief Implementation of the bf::level_editor class.
 * \author Julien Jorge.
 */
#include "bf/level_editor.hpp"

#include <wx/tooltip.h>
#include <claw/logger.hpp>

/*----------------------------------------------------------------------------*/
/**
 * \brief Constructor.
 */
bf::level_editor::level_editor()
  : m_locale( wxLocale::GetSystemLanguage() ), m_main_frame(NULL)
{
  claw::logger.set( new claw::console_logger() );
  claw::logger.set_level( claw::log_verbose );

  m_locale.AddCatalog( wxT("bear-factory") );

  srand(time(NULL));
} // level_editor::level_editor()

/*----------------------------------------------------------------------------*/
/**
 * \brief Destructor.
 */
bf::level_editor::~level_editor()
{
  // frames are deleted by wxWidgets

  claw::logger.clear();
} // level_editor::~level_editor()

/*----------------------------------------------------------------------------*/
/**
 * \brief Method called when the application is initializing.
 */
bool bf::level_editor::OnInit()
{
  wxToolTip::Enable(true);

  m_main_frame = new main_frame;
  m_main_frame->Show();

  for (int i=1; i<argc; ++i)
    try
      {
        m_main_frame->load_level( argv[i] );
      }
    catch( std::ios_base::failure& e )
      {
        claw::logger << claw::log_error << e.what()
                     << "\nCreating a new level." << std::endl;
        m_main_frame->new_level( argv[i] );
      }
    catch( std::exception& e )
      {
        claw::logger << claw::log_error << e.what() << std::endl;
      }

  return true;
} // level_editor::OnInit()
