/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [BEAR] in the subject of your mails.
*/
/**
 * \file real_game_variable_setter.hpp
 * \brief An item that sets the value of a real game variable.
 * \author Angibaud Sebastien
 */
#ifndef __BEAR_REAL_GAME_VARIABLE_SETTER_HPP__
#define __BEAR_REAL_GAME_VARIABLE_SETTER_HPP__

#include "engine/base_item.hpp"

#include "engine/export.hpp"
#include "generic_items/class_export.hpp"

namespace bear
{
  /**
   * \brief A item that sets the value of a real game variable.
   *
   * The valid fields for this item are
   *  - name The name of the variable to set.
   *  - value The new value of the variable. 
   *  - any field supported by the parent classes.
   *
   * \author Sebastien Angibaud
   */
  class GENERIC_ITEMS_EXPORT real_game_variable_setter:
    public engine::base_item
  {
    DECLARE_BASE_ITEM(real_game_variable_setter, bear);

  public:
    /** \brief The type of the parent class. */
    typedef engine::base_item super;

  public:
    real_game_variable_setter();

    void build();
    bool is_valid() const;
    bool set_real_field( const std::string& name, double value );
    bool set_string_field
    ( const std::string& name, const std::string& value );

  private:
    /** \brief The name of the variable. */
    std::string m_name;

    /** \brief The new value of the variable. */
    double m_value;
  }; // class real_game_variable_setter
} // namespace bear

#endif // __BEAR_REAL_GAME_VARIABLE_SETTER_HPP__
