/*
  Bear Engine

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [Bear] in the subject of your mails.
*/
/**
 * \file game_action_set_current_level.hpp
 * \brief Change the current level.
 * \author Julien Jorge
 */
#ifndef __ENGINE_GAME_ACTION_SET_CURRENT_LEVEL_HPP__
#define __ENGINE_GAME_ACTION_SET_CURRENT_LEVEL_HPP__

#include "engine/game_action/game_action.hpp"

#include <string>

#include "engine/level.hpp"
#include "engine/class_export.hpp"

namespace bear
{
  namespace engine
  {
    /**
     * \brief Change the current level.
     * \author Julien Jorge
     */
    class ENGINE_EXPORT game_action_set_current_level:
      public game_action
    {
    public:
      game_action_set_current_level( level* the_level );

      bool apply( game& the_game );

    private:
      /** \brief The level to set.. */
      level* m_level;

    }; // class game_action_set_current_level
  } // namespace engine
} // namespace bear

#endif // __ENGINE_GAME_ACTION_SET_CURRENT_LEVEL_HPP__
