/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) 2000  
 *     Brian Gerkey, Kasper Stoy, Richard Vaughan, & Andrew Howard
 *                      
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * $Id: wallclocktime.h,v 1.2 2005/08/08 03:53:21 gerkey Exp $
 *
 * this is the WallclockTime class, which just calls gettimeofday() to get
 * the current time
 *
 */
#ifndef _WALLCLOCKTIME_H
#define _WALLCLOCKTIME_H

#include <sys/time.h>

#include <libplayercore/playertime.h>

class WallclockTime : public PlayerTime
{
  public:
    int GetTime(struct timeval* time);
    int GetTimeDouble(double* time);
    ~WallclockTime() {}
};

#endif

