/* URI encoding for HTTP */

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include "uri.h"


static int Index_hex[128] = {
    -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
     0, 1, 2, 3,  4, 5, 6, 7,  8, 9,-1,-1, -1,-1,-1,-1,
    -1,10,11,12, 13,14,15,-1, -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
    -1,10,11,12, 13,14,15,-1, -1,-1,-1,-1, -1,-1,-1,-1,
    -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1
};

#define hexval(c) Index_hex[(unsigned int)(c)]


void uri_encode (char *d, size_t dl, const char *s)
{
  while (*s && --dl > 4)
  {
    if (*s == ' ' || *s == '%' || *s & 0x80)
    {
      sprintf (d, "%%%02x", (int) *s & 0xff);
      d += 3; dl -= 2;
    }
    else
      *d++ = *s;
    
    s++;
  }
  *d = '\0';
}

void uri_decode (char *d, size_t dl, const char *s)
{
  while (*s && --dl > 0)
  {
    if (*s == '%' && hexval(*(s+1)) >= 0 && hexval (*(s+2)) >= 0)
    {
      *d++ = (hexval (*(s+1)) << 4) | (hexval (*(s+2)));
      s += 3;
    }
    else
      *d++ = *s++;
  }
  
  *d = '\0';
}
  
