/* Copyright (c) 2001-2010, David A. Clunie DBA Pixelmed Publishing. All rights reserved. */

package com.pixelmed.doseocr;

import com.pixelmed.dose.*;

import junit.framework.*;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

import java.util.HashMap;
import java.util.Map;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TestOCRAgainstTabulatedData extends TestCase {
	
	// constructor to support adding tests to suite ...
	
	public TestOCRAgainstTabulatedData(String name) {
		super(name);
	}
	
	// add tests to suite manually, rather than depending on default of all test...() methods
	// in order to allow adding TestCTScanType.suite() in AllTests.suite()
	// see Johannes Link. Unit Testing in Java pp36-47
	
	public static Test suite() {
		TestSuite suite = new TestSuite("TestOCRAgainstTabulatedData");
		
		suite.addTest(new TestOCRAgainstTabulatedData("testOCRAgainstTabulatedData_AllFiles"));
		
		return suite;
	}
	
	protected void setUp() {
	}
	
	protected void tearDown() {
	}
	
	public void testOCRAgainstTabulatedData_AllFiles() throws Exception {
		String pathToTestImages = "../../../testpaths/DoseFilesCopied";
		String pathToTestData = "./doseocrcheck.dat";
		String pathToOcrGlyphs = "./OCR_Glyphs_GEDoseScreen.xml";
		
		Map<String,File> mapOfBaseNameToFile = new HashMap<String,File>();
		File[] files = new File(pathToTestImages).listFiles();
		for (int i=0; i<files.length; ++i) {
			String baseName = files[i].getName();
			if (!baseName.startsWith(".")) {
				mapOfBaseNameToFile.put(baseName,files[i]);
			}
		}
		
		//FILENAME	1.2.124.113532.10.8.8.91.20080701.165343.367049
		Pattern pFileName = Pattern.compile("FILENAME\t(.+)");
		
		//1	SCOUT	-	-	-	-	-	-	-
		//2	HELICAL	I	146.500	I	406.500	16.16	474.49	BODY32
		//200	AXIAL	I	84.250	I	84.250	13.39	13.40	BODY32
		Pattern pEvent = Pattern.compile("([0-9]+)[ \t]+(HELICAL|AXIAL)[ \t]+([SI])[ \t]+([0-9]*[.][0-9]*)[ \t]+([SI])[ \t]+([0-9]*[.][0-9]*)[ \t]+([0-9]*[.][0-9]*)[ \t]+([0-9]*[.][0-9]*)[ \t]+(.*)[ \t]*");
		//TOTAL 2413.44
		Pattern pTotal = Pattern.compile("TOTAL[ \t]+([0-9]*[.][0-9]*)");

		CTDose ctDoseFromOCR = null;
		CTDose ctDoseFromData = null;
		BufferedReader r = new BufferedReader(new FileReader(pathToTestData));
		String line = null;
		while ((line=r.readLine()) != null) {
			line=line.toUpperCase();
			Matcher mFileName = pFileName.matcher(line);
			if (mFileName.matches()) {
				String fileName = mFileName.group(1);		// first group is not 0, which is the entire match
//System.err.println("Matched file "+fileName);
				File imageFile = mapOfBaseNameToFile.get(fileName);
System.err.println("Processing file "+imageFile);
				OCR ocr = new OCR(imageFile.getCanonicalPath(),pathToOcrGlyphs,null,0/*debugLevel*/);
//System.err.println(ocr);
				ctDoseFromOCR = OCR.getCTDoseFromOCROfGEDoseScreen(ocr,0/*debugLevel*/,null/*startDateTime*/,null/*endDateTime*/,null,false);
//System.err.println(ctDoseFromOCR);
				assertFalse("check parse returned something",ctDoseFromOCR == null);
				ctDoseFromData = new CTDose(ScopeOfDoseAccummulation.STUDY,"0.0.0.0",null,null,"");
			}
			else {
				Matcher mTotal = pTotal.matcher(line);
				if (mTotal.matches()) {
					String dlpTotal = mTotal.group(1);		// first group is not 0, which is the entire match
//System.err.println("Matched total "+dlpTotal);
					ctDoseFromData.setDLPTotal(dlpTotal);
				}
				else {
					Matcher mEvent = pEvent.matcher(line);
					if (mEvent.matches()) {
//System.err.println("Matched event ");
						String series = mEvent.group(1);		// first group is not 0, which is the entire match
						String scanType = mEvent.group(2);
						String rangeFromSI = mEvent.group(3);
						String rangeFromLocation = mEvent.group(4);
						String rangeToSI = mEvent.group(5);
						String rangeToLocation = mEvent.group(6);
						String CTDIvol = mEvent.group(7);
						String DLP = mEvent.group(8);
						String phantom = mEvent.group(9).replaceAll("[ \t]+","").trim();
						CTScanType recognizedScanType = CTScanType.selectFromDescription(scanType);
						if (recognizedScanType != null && !recognizedScanType.equals(CTScanType.LOCALIZER)) {
//System.err.println("Adding acquisition ");
							ctDoseFromData.addAcquisition(new CTDoseAcquisition(series,recognizedScanType,new ScanRange(rangeFromSI,rangeFromLocation,rangeToSI,rangeToLocation),CTDIvol,DLP,CTPhantomType.selectFromDescription(phantom)));
						}
					}
					else if(line.startsWith("ENDFILE")) {
//System.err.println("From OCR:\n"+ctDoseFromOCR);
//System.err.println("From Data:\n"+ctDoseFromData);
						assertEquals("Checking DLP Total",ctDoseFromData.getDLPTotal(),ctDoseFromOCR.getDLPTotal());
						assertEquals("Checking totalNumberOfIrradiationEvents",ctDoseFromData.getTotalNumberOfIrradiationEvents(),ctDoseFromOCR.getTotalNumberOfIrradiationEvents());
						int n = ctDoseFromData.getTotalNumberOfIrradiationEvents();
						for (int i=0; i<n; ++i) {
							CTDoseAcquisition acqFromOCR = ctDoseFromOCR.getAcquisition(i);
							CTDoseAcquisition acqFromData = ctDoseFromData.getAcquisition(i);
System.err.println("From OCR:\n"+acqFromOCR);
System.err.println("From Data:\n"+acqFromData);
							assertTrue("Checking CTDoseAcquisition "+i+" equality",acqFromOCR.equals(acqFromData));
						}
					}
				}
			}
		}
	}
}

