/***************************************************************************
                          pipe.cpp  -  description
                             -------------------
    begin                : Wed Jan 10 1996
    copyright            : (C) 1996 by Waldemar Baraldi
    email                : baraldi@lacasilla.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "pipe.h"

Pipe::Pipe():AnimatedCanvas(){
  full_level=0;
  used_input=Void;
  ro=Void;
  fixed=false;
  bonus=NormalBonus;
  this->owner=NULL;
}


bool Pipe::isRemovable(){
  return !(full_level>0) && !fixed;
}

void Pipe::setFixed(bool flag=true){
  fixed=flag;
}

void Pipe::setBonus(Bonus bonus=NormalBonus){
  this->bonus=bonus;
}

Bonus Pipe::getBonus(){
  return bonus;
}

void Pipe::setOwner(Player * owner){
  this->owner=owner;
}

Player * Pipe::getOwner(){
  return owner;
}

void Pipe::paintRestriction(VideoManager * vm, CardinalPoint con){
  Image * ima;
  switch (con){
    case West:{
      ima=(vm->getImageManager())->getImage(new Str("arrow_w.png"));
      vm->blit(ima, x, y);
      break;
    }
    case South:{
      ima=(vm->getImageManager())->getImage(new Str("arrow_s.png"));
      vm->blit(ima, x, y);
      break;
    }
    case East:{
      ima=(vm->getImageManager())->getImage(new Str("arrow_e.png"));
      vm->blit(ima, x, y);
      break;
    }
    case North:{
      ima=(vm->getImageManager())->getImage(new Str("arrow_n.png"));
      vm->blit(ima, x, y);
      break;
    }
    default:break;
  }
}

void Pipe::paintBonus(VideoManager * vm, Bonus bonus){
  Image * ima;
  switch (bonus){
    case SuperBonus:{
      ima=(vm->getImageManager())->getImage(new Str("super_bonus.png"));
      vm->blit(ima, x, y);
      break;
    }
    case UltraBonus:{
      ima=(vm->getImageManager())->getImage(new Str("ultra_bonus.png"));
      vm->blit(ima, x, y);
      break;
    }
    case HyperBonus:{
      ima=(vm->getImageManager())->getImage(new Str("hyper_bonus.png"));
      vm->blit(ima, x, y);
      break;
    }
    case LifeBonus:{
      ima=(vm->getImageManager())->getImage(new Str("life_bonus.png"));
      vm->blit(ima, x, y);
      break;
    }
    default:break;
  }
}


