/*
 * PIMPPA - pnewsrv (Adds a new newsserver, or changes old one)
 *
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include <unistd.h>
#include <sys/stat.h>
#include <string.h>

#include "pimppa.h"

void usage(char *progname)
{
	fprintf(stderr, "Usage: %s -s <name> [options]\n\n%s", progname,
	"-s <server_name>   Server name, MUST\n"
	"-u <user>          Optional username\n"
	"-p <pass>          Optional password\n"
	"-i <server_id>     Suggest newsserver id\n");
}

int main(int argc, char *argv[])
{
	char server[PATH_MAX];
	char user[PATH_MAX];
	char pass[PATH_MAX];
	int id=0;
	MYSQL *db;
	int go=1;

	server[0]=user[0]=pass[0]=0;

	while(go)
	{
		switch(getopt(argc, argv, "hs:u:p:i:V"))
		{
			case 's':
				strcpy(server, optarg);
				break;
			case 'u':
				strcpy(user, optarg);
				break;
			case 'p':
				strcpy(pass, optarg);
				break;
			case 'i':
				id=atoi(optarg);
				break;
			case -1:
				go=0;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			case 'h':
			default:
				usage(argv[0]);
				return(0);
				break;
		}
	}
	
	if(!server[0])
	{
		fprintf(stderr, "Please supply server name with -s <server_name>\n");
		return(0);
	}	

	db=p_connect();
	if(!db)
		return(-1);

/****************** Ok, lets add **********************/

	if(id)
	{
		p_query(db, "REPLACE INTO p_servers "
			    "  (s_name, s_user, s_pass, s_id) "
			    "VALUES ('%s', '%s', '%s', '%d')", 
			server, user, pass, id);
	}
	else
	{
		p_query(db, "REPLACE INTO p_servers "
			    "  (s_name, s_user, s_pass) "
			    "VALUES ('%s', '%s', '%s')", 
			server, user, pass);
	}
	if(mysql_error(db)[0])
	{
		mysql_close(db);
		fprintf(stderr, "Unable to add the server (%s)...\n",
				mysql_error(db));
		return(-1);
	}

	mysql_close(db);

	fprintf(stderr, "Ok...\n");

	return(0);
}

