/* 
   Copyright (C) Andrew Tridgell 2000
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#define _XOPEN_SOURCE 500
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/io.h>
#include <sys/mman.h>
#include <dirent.h>
#include <ctype.h>
#include <malloc.h>
#include <string.h>
#include <signal.h>
#include <getopt.h>
#include <linux/pci.h>
#include <sys/time.h>
#include "mchip.h"

typedef unsigned char u8;
typedef unsigned short u16;
typedef unsigned u32;

#define CAPTURE_VERSION "0.2"

#include "avi.h"

#define PAGE_SIZE 0x1000

#define SONYPI_DEV "/proc/bus/pci/00/07.3"

#define SPIC_PCI_VENDOR 0x8086
#define SPIC_PCI_DEVICE 0x7113

/* the irq selection is 2 bits in the following port */
#define SPI_IRQ_PORT 0x8034
#define SPI_IRQ_SHIFT 22

#define SPI_BASE 0x50

#define SPI_G10A (SPI_BASE+0x14)
#define SPI_G10L (SPI_BASE+0x16) /* 4 bits at this offset - the port offset of
				    2nd port from first */

extern int mchip_dev;
extern int debug;
extern int image_quality;
extern void *mchip_base;

#include "proto.h"
