<?php
	/***************************************************************************\
	* phpGroupWare - Notes                                                      *
	* http://www.phpgroupware.org                                               *
	* Written by : Bettina Gille [ceb@phpgroupware.org]                         *
	*              Andy Holman (LoCdOg)                                         *
	* -------------------------------------------------                         *
	* Copyright 2000 - 2003 Free Software Foundation, Inc               		*
	*                                                                           *
	* This program is free software; you can redistribute it and/or modify it   *
	* under the terms of the GNU General Public License as published by the     *
	* Free Software Foundation; either version 2 of the License, or (at your    *
	* option) any later version.                                                *
	\***************************************************************************/
	/* $Id: class.sonotes.inc.php,v 1.10.2.3 2006/10/24 13:53:14 skwashd Exp $ */

	class sonotes
	{
		var $grants;
		var $db;
		var $db2;
		var $owner;
		var $total_records;

		function sonotes()
		{
			$this->db     = $GLOBALS['phpgw']->db;
			$this->db2    = $this->db;
			$this->grants = $GLOBALS['phpgw']->acl->get_grants('notes');
			$this->owner  = intval($GLOBALS['phpgw_info']['user']['account_id']);
		}

		function read_notes($start, $search = '', $filter = '',$cat_id = '', $limit = True, $lastmod = -1)
		{
			//cast/addslashes for security
			$start		= intval($start);
			$cat_id		= intval($cat_id);
			$lastmod	= intval($lastmod);
			$search		= $this->db->db_addslashes($search);
			
			if (! $filter)
			{
				$filter = 'all';
			}

			if ($filter == 'all')
			{
				$filtermethod = " ( note_owner=" . $this->owner;
				if (is_array($this->grants))
				{
					$grants = $this->grants;
					while (list($user) = each($grants))
					{
						$public_user_list[] = $user;
					}
					reset($public_user_list);
					$filtermethod .= " OR (note_access='public' AND note_owner in(" . implode(',',$public_user_list) . ")))";
				}
				else
				{
					$filtermethod .= ' )';
				}
			}
			elseif ($filter == 'public')
			{
				$filtermethod = " note_owner='" . $this->owner . "'";
			}
			else
			{
				$filtermethod = " note_owner='" . $this->owner . "' AND note_access='private'";
			}

			if ($lastmod >= 0)
			{
				$filtermethod .= ' AND note_date > ' . intval($lastmod) . ' ';
			}

			if ($cat_id)
			{
				$filtermethod .= ' AND note_category=' . intval($cat_id) . ' ';
			}

			if ($search)
			{
				$searchmethod = " AND note_content like '%".$this->db->db_addslashes($search)."%'";
			}
			
			$sql = "SELECT * FROM phpgw_notes WHERE $filtermethod $searchmethod ORDER BY note_date DESC";

			$this->db2->query($sql,__LINE__,__FILE__);
			$this->total_records = $this->db2->num_rows();
			if($limit)
			{
				$this->db->limit_query($sql,$start,__LINE__,__FILE__);
			}
			else
			{
				$this->db->query($sql,__LINE__,__FILE__);
			}

			$i = 0;
			while ($this->db->next_record())
			{
				$notes[$i]['id']	= intval($this->db->f('note_id'));
				$notes[$i]['owner']	= $this->db->f('note_owner');
				$notes[$i]['owner_id']	= intval($this->db->f('note_owner'));
				$notes[$i]['access']	= $this->db->f('note_access');
				$notes[$i]['date']	= $this->db->f('note_date');
				$notes[$i]['category']	= intval($this->db->f('note_category'));
				$notes[$i]['content']	= $this->db->f('note_content', True);
				$notes[$i]['grants']	= intval($this->grants[$this->db->f('note_owner')]);
				$notes[$i]['lastmod']	= intval($this->db->f('note_date'));
				$i++;
			}
			return $notes;
		}

		function read_single_note($note_id)
		{
			$this->db->query('SELECT * FROM phpgw_notes WHERE note_id=' . intval($note_id),__LINE__,__FILE__);

			if ($this->db->next_record())
			{
				$note['id']		= intval($this->db->f('note_id'));
				$note['owner']		= $this->db->f('note_owner');
				$note['content']	= $this->db->f('note_content', True);
				$note['access']		= $this->db->f('note_access');
				$note['date']		= $this->db->f('note_date');
				$note['category']	= intval($this->db->f('note_category'));

				return $note;
			}
		}

		function add_note($note)
		{
			//cast/addslashes for security
			$note['access']  = $this->db->db_addslashes($note['access']);
			$note['content'] = $this->db->db_addslashes($note['content']);
			$note['category']= intval($note['category']);
			
			$this->db->query("INSERT INTO phpgw_notes (note_owner,note_access,note_date,note_content,note_category) "
				. "VALUES (" . $this->owner . ",'" . $note['access'] . "'," . time() . ",'" . $note['content']
				. "'," . $note['category'] . ")",__LINE__,__FILE__);
			return $this->db->get_last_insert_id('phpgw_notes','note_id');
		}

		function edit_note($note)
		{
			//cast/addslashes for security
			$note['id']      = intval($note['id']);
			$note['access']  = $this->db->db_addslashes($note['access']);
			$note['content'] = $this->db->db_addslashes($note['content']);
			$note['category']= intval($note['category']);

			$this->db->query("UPDATE phpgw_notes set note_content='" . $note['content'] . "', note_date=" . time() . ", note_category=" . $note['category'] . ", "
				. "note_access='" . $note['access'] . "' WHERE note_id=" . $note['id'],__LINE__,__FILE__);
		}

		function delete_note($note_id)
		{
			$note_id = (int) $note_id;
			$this->db->query('DELETE FROM phpgw_notes WHERE note_id=' . intval($note_id),__LINE__,__FILE__);
		}
	}
?>
