<?php
  /**************************************************************************\
  * phpGroupWare app (Bookkeeping)                                           *
  * http://www.phpgroupware.org                                              *
  * Written by Rick Bakker <r.bakker@linvision.com>                          *
  * --------------------------------------------                             *
  *  This program is free software; you can redistribute it and/or modify it *
  *  under the terms of the GNU General Public License as published by the   *
  *  Free Software Foundation; either version 2 of the License, or (at your  *
  *  option) any later version.                                              *
  \**************************************************************************/

  // HTTP_GET_VARS
  $order=$HTTP_GET_VARS['order'];
  $selected=$HTTP_GET_VARS['selected'];
  $error_id=$HTTP_GET_VARS['error_id'];
  $script=$HTTP_GET_VARS['script'];
  $entry_id=$HTTP_GET_VARS['entry_id'];

  $phpgw_info["flags"]["currentapp"]="bookkeeping";
  include("../header.inc.php");
  include("inc/bookkeeping_header.inc.php");

  $phpgw->template->set_file(array( "message" => "message.tpl"));

  $phpgw->template->set_var("header",$header);
  $phpgw->template->set_var("lang_app_title",lang("bookkeeping"));
  $phpgw->template->set_var("head_color","D3DCE3");

  if($script=='entry_add.php')
  {
    $lang_title=lang("entries");
    if($selected=='expenses')
    {     
      $lang_selected=lang("add_expense");
    }
    else
    {
       $lang_selected=lang("add_income");
    }
    $lang_proceed='<a href="'.$phpgw->link("entry_add.php","selected=$selected&order=$order").'">'.lang("proceed".'</a>');
    if($error_id==1)
    {
      $message="You entered an invalid date";
    }
    if($error_id==2)
    {
      $message="You entered no amount";
    }
  }

  if($script=='entry_edit.php')
  {
    $lang_title=lang("entries");
    if($selected=='expenses')
    {
      $lang_selected=lang("edit_expense");
    }
    else
    {
       $lang_selected=lang("edit_income");
    }
    $lang_proceed='<a href="'.$phpgw->link("entry_edit.php","entry_id=$entry_id&selected=$selected&order=$order").'">'.lang("proceed".'</a>');
    if($error_id==1)
    {
      $message="You entered an invalid date";
    }
    if($error_id==2)
    {
      $message="You entered no amount";
    }
  }

  $phpgw->template->set_var("lang_title",$lang_title);
  $phpgw->template->set_var("lang_selected",$lang_selected);
  $phpgw->template->set_var("lang_proceed",$lang_proceed);

  $lang_message=lang($message);
  $phpgw->template->set_var("lang_message",$lang_message);

  $phpgw->template->parse("out", "message", true);
  $phpgw->template->p("out");

  $phpgw->common->phpgw_footer();


?>
