<?php
/**
*
* common [Serbian]
*
* @package language
* @version $Id$
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'Превод - <a href="http://www.medicinari.com/" target="_new">medicinari.com</a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d.m.Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'sr-rs',

	'1_DAY'			=> '1 дан',
	'1_MONTH'		=> '1 месец',
	'1_YEAR'		=> '1 година',
	'2_WEEKS'		=> '2 недеље',
	'3_MONTHS'		=> '3 месеца',
	'6_MONTHS'		=> '6 месеци',
	'7_DAYS'		=> '7 дана',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Ваш налог је већ активиран.',
	'ACCOUNT_DEACTIVATED'			=> 'Ваш налог је ручно деактивиран и може га поново активирати само администратор.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Ваш налог још није активиран.',
	'ACP'							=> 'Админ Контролна Плоча',
	'ACTIVE'						=> 'активни',
	'ACTIVE_ERROR'					=> 'Изабрано корисничко име је тренутно неактивно. Ако имате сметњи у активацији Вашег налога, молимо Вас да се повежете са администратором.',
	'ADMINISTRATOR'					=> 'Администратор',
	'ADMINISTRATORS'				=> 'Администратори',
	'AGE'							=> 'Година',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Дозвољен',
	'ALL_FILES'						=> 'Све датотеке',
	'ALL_FORUMS'					=> 'Сви форуми',
	'ALL_MESSAGES'					=> 'Све поруке',
	'ALL_POSTS'						=> 'Све поруке',
	'ALL_TIMES'						=> 'Сва времена су у %1$s %2$s',
	'ALL_TOPICS'					=> 'Све теме',
	'AND'							=> 'И',
	'ARE_WATCHING_FORUM'			=> 'Пријавили сте се да примате обавештења о новим порукама у овом форуму.',
	'ARE_WATCHING_TOPIC'			=> 'Пријавили сте се да примате обавештења о новим порукама у овој теми.',
	'ASCENDING'						=> 'Узлазно',
	'ATTACHMENTS'					=> 'Прилози',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'Слика коју покушавате да приложите је неисправна.',
	'AUTHOR'						=> 'Аутору',
	'AUTH_NO_PROFILE_CREATED'		=> 'Неуспешно прављење корисничког профила.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'Додавање је одбијено јер је додата датотека препозната као могући покушај напада.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'Ова датотека не може бити приказана јер екстензија <strong>%s</strong> није дозвољена.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'Изабрани грб није могуће додати јер се удаљени подаци појављују као неисправни или загађени.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'Додата датотека грба је празна.',
	'AVATAR_INVALID_FILENAME'		=> '%s је неисправно име датотеке.',
	'AVATAR_NOT_UPLOADED'			=> 'Грб не може бити додат.',
	'AVATAR_NO_SIZE'				=> 'Ширина или висина повезаног грба не може бити утврђена. Молимо Вас унесите их ручно.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'Изабрана датотека је само делимично додата.',
	'AVATAR_PHP_SIZE_NA'			=> 'Величина датотеке грба је превелика.<br />Највећа дозвољена величина постављена у php.ini не може бити утврђена.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'Величина датотеке грба је превелика. Највећа дозвољена величина за додавање је %1$d %2$s.<br />Молимо знајте да је ово подешено у php.ini и да се не може заобићи.',
	'AVATAR_URL_INVALID'			=> 'URL који сте изабрали је неисправан.',
	'AVATAR_URL_NOT_FOUND'			=> 'Датотека коју сте изабрали не може бити пронађена.',
	'AVATAR_WRONG_FILESIZE'			=> 'Величина датотеке грба мора бити између 0 и %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'Поднети грб је %5$d пиксела широк и %6$d пиксела висок. Грбови морају бити бар %1$d пиксела широки и %2$d пиксела високи, али не већи од %3$d пиксела у ширину и %4$d пиксела у висину.',

	'BACK_TO_TOP'			=> 'Врх',
	'BACK_TO_PREV'			=> 'Назад на претходну страницу',
	'BAN_TRIGGERED_BY_EMAIL'=> 'Додељена је забрана Вашој мејл адреси.',
	'BAN_TRIGGERED_BY_IP'	=> 'Додељена је забрана Вашој IP адреси.',
	'BAN_TRIGGERED_BY_USER'	=> 'Додељена је забрана Вашем корисничком имену.',
	'BBCODE_GUIDE'			=> 'ББКод водич',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'Рођендани',
	'BOARD_BAN_PERM'		=> 'Ви сте <strong>трајно</strong> под забраном на овом форуму.<br /><br />Молимо Вас да се повежете са %2$sАдминистратором форума%3$s за више података.',
	'BOARD_BAN_REASON'		=> 'Разлог за забрану: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'Забрањени сте на овом форуму до <strong>%1$s</strong>.<br /><br />Молимо Вас да се повежете са %2$sАдминистратором форума%3$s за више података.',
	'BOARD_DISABLE'			=> 'Жао нам је али овај форум тренутно није доступан.',
	'BOARD_DISABLED'		=> 'Овај форум је тренутно затворен.',
	'BOARD_UNAVAILABLE'		=> 'Жао нам је али овај форум тренутно није доступан, молимо Вас да пробате поново за неколико минута.',
	'BROWSING_FORUM'		=> 'Корисника прегледа овај форум: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'Корисника прегледа овај форум: %1$s и %2$d гост',
	'BROWSING_FORUM_GUESTS'	=> 'Корисника прегледа овај форум: %1$s и %2$d госта',
	'BYTES'					=> 'Бајта',

	'CANCEL'				=> 'Одустани',
	'CHANGE'				=> 'Промени',
	'CHANGE_FONT_SIZE'		=> 'Промени величину текста',
	'CHANGING_PREFERENCES'	=> 'Промена поставки форума',
	'CHANGING_PROFILE'		=> 'Промена поставки профила',
	'CLICK_VIEW_PRIVMSG'	=> '%sИдите у Ваше сандуче%s',
	'COLLAPSE_VIEW'			=> 'Сажет преглед',
	'CLOSE_WINDOW'			=> 'Затвори прозор',
	'COLOUR_SWATCH'			=> 'Замена боје',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'Потврди',
	'CONFIRM_CODE'			=> 'Код за потврду',
	'CONFIRM_CODE_EXPLAIN'	=> 'Унесите код тачно онако како се појављује. Осетљиво на велика и мала слова, нема нуле.',
	'CONFIRM_CODE_WRONG'	=> 'Код за потврду који сте унели није исправан.',
	'CONFIRM_OPERATION'		=> 'Да ли сигурно желите да извршите овај поступак?',
	'CONGRATULATIONS'		=> 'Честитамо',
	'CONNECTION_FAILED'		=> 'Повезивање није успело.',
	'CONNECTION_SUCCESS'	=> 'Повезивање је било успешно!',
	'COOKIES_DELETED'		=> 'Сви колачићи форума су успешно обрисани.',
	'CURRENT_TIME'			=> 'Данас је %s',

	'DAY'					=> 'Дан',
	'DAYS'					=> 'Дани',
	'DELETE'				=> 'Обриши',
	'DELETE_ALL'			=> 'Обриши све',
	'DELETE_COOKIES'		=> 'Обриши све колачиће форума',
	'DELETE_MARKED'			=> 'Обриши означене',
	'DELETE_POST'			=> 'Обриши поруку',
	'DELIMITER'				=> 'Граничник',
	'DESCENDING'			=> 'Силазно',
	'DISABLED'				=> 'Онемогућено',
	'DISPLAY'				=> 'Приказ',
	'DISPLAY_GUESTS'		=> 'Приказ госта',
	'DISPLAY_MESSAGES'		=> 'Приказ порука у последњих',
	'DISPLAY_POSTS'			=> 'Приказ порука у последњих',
	'DISPLAY_TOPICS'		=> 'Приказ тема у последњих',
	'DOWNLOADED'			=> 'Преузето',
	'DOWNLOADING_FILE'		=> 'Преузимање датотеке',
	'DOWNLOAD_COUNT'		=> 'Преузето %d пут',
	'DOWNLOAD_COUNTS'		=> 'Преузето %d пута',
	'DOWNLOAD_COUNT_NONE'	=> 'Још није преузето',
	'VIEWED_COUNT'			=> 'Прегледано %d пут',
	'VIEWED_COUNTS'			=> 'Прегледано %d пута',
	'VIEWED_COUNT_NONE'		=> 'Још није прегледано',

	'EDIT_POST'							=> 'Учитај поруку',
	'EMAIL'								=> 'Мејл', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'Мејл адреса',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Дошло је до сметњи приликом слања мејла у <strong>Линији %1$s</strong>. Одговор: %2$s.',
	'EMPTY_SUBJECT'						=> 'Морате унети наслов када пишете нову тему.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'Морате унети наслов када пишете нову поруку.',
	'ENABLED'							=> 'Омогућено',
	'ENCLOSURE'							=> 'Ограђивање',
	'ERR_CHANGING_DIRECTORY'			=> 'Није могуће променити фасциклу.',
	'ERR_CONNECTING_SERVER'				=> 'Грешка при повезивању на сервер.',
	'ERR_JAB_AUTH'						=> 'Не могу да се потврдим на Jabber сервер.',
	'ERR_JAB_CONNECT'					=> 'Не могу да се повежем на Jabber сервер.',
	'ERR_UNABLE_TO_LOGIN'				=> 'Изабрано корисничко име или лозинка је неисправно.',
	'ERR_UNWATCHING'					=> 'Појавила се грешка приликом покушаја престанка праћења.',
	'ERR_WATCHING'						=> 'Појавила се грешка приликом покушаја праћења.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'phpBB путања коју сте унели је неисправна.',
	'EXPAND_VIEW'						=> 'Проширен приказ',
	'EXTENSION'							=> 'Екстензија',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'Екстензија <strong>%s</strong> је деактивирана и не може више бити приказана.',

	'FAQ'					=> 'ЧПП',
	'FAQ_EXPLAIN'			=> 'Често Постављана Питања',
	'FILENAME'				=> 'Назив датотеке',
	'FILESIZE'				=> 'Величина датотеке',
	'FILEDATE'				=> 'Датум датотеке',
	'FILE_COMMENT'			=> 'Коментар датотеке',
	'FILE_NOT_FOUND'		=> 'Тражена датотека не може бити пронађена.',
	'FIND_USERNAME'			=> 'Пронађи члана',
	'FOLDER'				=> 'Фасцикла',
	'FORGOT_PASS'			=> 'Заборавио сам моју лозинку',
	'FORM_INVALID'			=> 'Прослеђени образац није исправан. Покушајте поново.',
	'FORUM'					=> 'Форум',
	'FORUMS'				=> 'Форуми',
	'FORUMS_MARKED'			=> 'Сви форуми су означени као прочитани.',
	'FORUM_CAT'				=> 'Категорија форума',
	'FORUM_INDEX'			=> 'Почетна форума',
	'FORUM_LINK'			=> 'Веза форума',
	'FORUM_LOCATION'		=> 'Место на форуму',
	'FORUM_LOCKED'			=> 'Закључан форум',
	'FORUM_RULES'			=> 'Правила форума',
	'FORUM_RULES_LINK'		=> 'Молимо кликните овде да прочитате правила форума',
	'FROM'					=> 'од',
	'FSOCK_DISABLED'		=> 'Поступак не може бити употпуњен јер је <var>fsockopen</var> функција онемогућена или је сервер презаузет односно недоступан.',

	'FTP_FSOCK_HOST'				=> 'FTP сервер',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP сервер који се користи за повезивање са Вашом веб страницом.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP лозинка',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Лозинка за Ваше FTP корисничко име.',
	'FTP_FSOCK_PORT'				=> 'FTP порт',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Порт који се користи за повезивање са Вашим сервером.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Путања до phpBB-а',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Путања од root-а до Вашег phpBB форума.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP застој',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'Количина времена, у секундама, колико ће систем чекати на одговор од Вашег сервера.',
	'FTP_FSOCK_USERNAME'			=> 'FTP корисничко име',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Корисничко име које се користи за повезивање са Вашим сервером.',

	'FTP_HOST'					=> 'FTP сервер',
	'FTP_HOST_EXPLAIN'			=> 'FTP сервер који се користи за повезивање са Вашом веб страницом.',
	'FTP_PASSWORD'				=> 'FTP лозинка',
	'FTP_PASSWORD_EXPLAIN'		=> 'Лозинка за Ваше FTP корисничко име.',
	'FTP_PORT'					=> 'FTP порт',
	'FTP_PORT_EXPLAIN'			=> 'Порт који се користи за повезивање са Вашим сервером.',
	'FTP_ROOT_PATH'				=> 'Путања до phpBB-a',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Путања од root-а до Вашег phpBB форума.',
	'FTP_TIMEOUT'				=> 'FTP застој',
	'FTP_TIMEOUT_EXPLAIN'		=> 'Количина времена, у секундама, колико ће систем чекати на одговор од Вашег сервера.',
	'FTP_USERNAME'				=> 'FTP корисничко име',
	'FTP_USERNAME_EXPLAIN'		=> 'Корисничко име које се користи за повезивање са Вашим сервером.',

	'GENERAL_ERROR'				=> 'Општа грешка',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'Иди',
	'GOTO_PAGE'					=> 'Иди на страницу',
	'GROUP'						=> 'Група',
	'GROUPS'					=> 'Групе',
	'GROUP_ERR_TYPE'			=> 'Изабран је неподесан тип групе.',
	'GROUP_ERR_USERNAME'		=> 'Није изабран назив групе.',
	'GROUP_ERR_USER_LONG'		=> 'Назив групе не може да премаши 60 знакова. Изабрани назив групе је предугачак.',
	'GUEST'						=> 'Гост',
	'GUEST_USERS_ONLINE'		=> 'Има %d госта на вези',
	'GUEST_USERS_TOTAL'			=> '%d госта',
	'GUEST_USERS_ZERO_ONLINE'	=> 'Има 0 госта на вези',
	'GUEST_USERS_ZERO_TOTAL'	=> '0 госта',
	'GUEST_USER_ONLINE'			=> 'Има %d гост на вези',
	'GUEST_USER_TOTAL'			=> '%d гост',
	'G_ADMINISTRATORS'			=> 'Администратори',
	'G_BOTS'					=> 'Роботи',
	'G_GUESTS'					=> 'Гости',
	'G_REGISTERED'				=> 'Регистровани корисници',
	'G_REGISTERED_COPPA'		=> 'Регистровани COPPA корисници',
	'G_GLOBAL_MODERATORS'		=> 'Општи уредници',
	'G_NEWLY_REGISTERED'		=> 'Новорегистровани корисници',

	'HIDDEN_USERS_ONLINE'			=> '%d сакривених на вези',
	'HIDDEN_USERS_TOTAL'			=> '%d сакривених',
	'HIDDEN_USERS_TOTAL_AND'		=> '%d сакривених и ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> '0 сакривених на вези',
	'HIDDEN_USERS_ZERO_TOTAL'		=> '0 сакривених',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> '0 сакривених и ',
	'HIDDEN_USER_ONLINE'			=> '%d сакривени корисник на вези',
	'HIDDEN_USER_TOTAL'				=> '%d сакривени',
	'HIDDEN_USER_TOTAL_AND'			=> '%d сакривени и ',
	'HIDE_GUESTS'					=> 'Сакриј госте',
	'HIDE_ME'						=> 'Сакриј мој статус На вези за ову сесију',
	'HOURS'							=> 'Сати',
	'HOME'							=> 'Почетна',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ статус',
	'IF'						=> 'Ако',
	'IMAGE'						=> 'Слика',
	'IMAGE_FILETYPE_INVALID'	=> 'Тип датотеке слике %d за mimetype %s није подржан.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Тип датотеке слике се не слаже: очекивана екстензија је %1$s а дата је %2$s.',
	'IN'						=> 'у',
	'INDEX'						=> 'Почетна страница',
	'INFORMATION'				=> 'Информација',
	'INTERESTS'					=> 'Занимања',
	'INVALID_DIGEST_CHALLENGE'	=> 'Invalid digest challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> вероватно неисправна мејл адреса?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Ваш IP %1$s је блокиран јер се налази на црној листи. За детаље молимо погледајте <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'Придружен',
	'JUMP_PAGE'				=> 'Унесите број странице на коју желите да идете',
	'JUMP_TO'				=> 'Скочи на',
	'JUMP_TO_PAGE'			=> 'Кликните да бисте скочили на страницу…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'Задња порука',
	'LAST_UPDATED'						=> 'Последњи пут измењено',
	'LAST_VISIT'						=> 'Последња посета',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP екстензија није доступна.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Не могу да се повежем на LDAP сервер.',
	'LEGEND'							=> 'Легенда',
	'LOCATION'							=> 'Место',
	'LOCK_POST'							=> 'Закључај поруку',
	'LOCK_POST_EXPLAIN'					=> 'Заштити од учитавања',
	'LOCK_TOPIC'						=> 'Закључај тему',
	'LOGIN'								=> 'Пријава',
	'LOGIN_CHECK_PM'					=> 'Пријавите се како бисте проверили Ваше приватне поруке.',
	'LOGIN_CONFIRMATION'				=> 'Потврда пријаве',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'Да бисмо спречили брутално силовање налога администратор форума захтева да унесете код за потврду после највећег дозвољеног броја погрешних пријава. Код је приказан у слици коју би требало да видите испод. Уколико нисте у могућности да прочитате код молимо Вас да се повежете са %sАдминистратором форума%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'Прекорачили сте највећи дозвољени број покушаја пријаве. У додатку Вашем корисничком имену и лозинци сада морате такође и да унесете код за потврду са слике коју видите испод.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Нисте овлашћени од Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'Изабрали сте неисправну лозинку. Молимо Вас да проверите Вашу лозинку и пробате поново. Уколико и даље наставите да имате сметњи молимо Вас да се повежете са %sАдминистратором форума%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'Није било могуће пребацити Вашу лозинку у току надоградње овог форума. Молимо Вас да %sпотражите нову лозинку%s. Уколико и даље наставите да имате сметњи молимо Вас да се повежете са %sАдминистратором форума%s.',
	'LOGIN_ERROR_USERNAME'				=> 'Изабрали сте неисправно корисничко име. Молимо Вас да проверите корисничко име и пробате поново. Уколико и даље наставите да имате сметњи молимо Вас да се повежете са %sАдминистратором форума%s.',
	'LOGIN_FORUM'						=> 'Да бисте писали или прегледали овај форум, морате унети његову лозинку.',
	'LOGIN_INFO'						=> 'У настојањима да се пријавите прво морате да се региструјете. Регистрација траје само неколико тренутака али Вам даје повећане могућности. Администратор форума може такође доделити додатне дозволе регистрованим корисницима. Пре него што се региструјете упознајте се са нашим условима коришћења. Потрудите се и да прочитате сва правила форума док користите форум.',
	'LOGIN_VIEWFORUM'					=> 'Форум захтева од Вас да будете регистровани и пријављени како бисте могли да прегледате овај форум.',
	'LOGIN_EXPLAIN_EDIT'				=> 'При покушају да учитате поруке у овом форуму морате бити регистровани и пријављени.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'При покушају да прегледате списак На вези морате бити регистровани и пријављени.',
	'LOGOUT'							=> 'Одјавa',
	'LOGOUT_USER'						=> 'Одјави [ %s ]',
	'LOG_ME_IN'							=> 'Пријави ме аутоматски при свакој посети',

	'MARK'					=> 'Означи',
	'MARK_ALL'				=> 'Означи све',
	'MARK_FORUMS_READ'		=> 'Означи све форуме као прочитане',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Контролна Плоча Уредника',
	'MEMBERLIST'			=> 'Чланови',
	'MEMBERLIST_EXPLAIN'	=> 'Преглед потпуног списка чланова',
	'MERGE'					=> 'Спој',
	'MERGE_POSTS'			=> 'Спој поруке',
	'MERGE_TOPIC'			=> 'Спој теме',
	'MESSAGE'				=> 'Порука',
	'MESSAGES'				=> 'поруке',
	'MESSAGE_BODY'			=> 'Тело поруке',
	'MINUTES'				=> 'Минута',
	'MODERATE'				=> 'Уређивати',
	'MODERATOR'				=> 'уредник',
	'MODERATORS'			=> 'уредници',
	'MONTH'					=> 'Месец',
	'MOVE'					=> 'Помери',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'Наш најновији члан је <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'Нова порука',
	'NEW_MESSAGES'				=> 'Нове поруке',
	'NEW_PM'					=> '<strong>%d</strong> нову поруку',
	'NEW_PMS'					=> '<strong>%d</strong> нове поруке',
	'NEW_POST'					=> 'Нова порука',
	'NEW_POSTS'					=> 'Нове поруке',
	'NEXT'						=> 'Следећа',		// Used in pagination
	'NEXT_STEP'					=> 'Даље',
	'NEVER'						=> 'Никада',
	'NO'						=> 'Не',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'Немате дозволу да управљате овом групом.',
	'NOT_AUTHORISED'			=> 'Нисте овлашћени да приступите овој области.',
	'NOT_WATCHING_FORUM'		=> 'Нисте више пријављени да примате обавештења о овом форуму.',
	'NOT_WATCHING_TOPIC'		=> 'Нисте више пријављени да примате обавештења о овој теми.',
	'NOTIFY_ADMIN'				=> 'Молимо Вас да обавестите администратора.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Молимо Вас да обавестите администратора: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'Немате дозволу да приступите овој датотеци.',
	'NO_ACTION'					=> 'Није изабран поступак.',
	'NO_ADMINISTRATORS'			=> 'Нема администратора.',
	'NO_AUTH_ADMIN'				=> 'Не можете приступити админ контролној плочи јер немате дозволе администратора.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'Не можете се поново потврдити као други корисник.',
	'NO_AUTH_OPERATION'			=> 'Немате потребне дозволе да употпуните овај поступак.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Не могу да се повежем на smtp сервер : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'Данас нема рођендана',
	'NO_EMAIL_MESSAGE'			=> 'Мејл порука је празна.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Не могу да добијем одговор мејл сервера.',
	'NO_EMAIL_SUBJECT'			=> 'Није унет наслов мејла.',
	'NO_FORUM'					=> 'Форум који сте изабрали не постоји.',
	'NO_FORUMS'					=> 'Овај форум нема форуме.',
	'NO_GROUP'					=> 'Тражена корисничка група не постоји.',
	'NO_GROUP_MEMBERS'			=> 'Ова група тренутно нема чланова.',
	'NO_IPS_DEFINED'			=> 'Нису одређене IP адресе или Хостови',
	'NO_MEMBERS'				=> 'Нису пронађени чланови по овим мерила претраге.',
	'NO_MESSAGES'				=> 'Нема порука',
	'NO_MODE'					=> 'Није изабран мод.',
	'NO_MODERATORS'				=> 'Нема уредника.',
	'NO_NEW_MESSAGES'			=> 'Нема нових порука',
	'NO_NEW_PM'					=> '<strong>0</strong> нових порука',
	'NO_NEW_POSTS'				=> 'Нема нових порука',
	'NO_ONLINE_USERS'			=> 'Нема регистрованих корисника',
	'NO_POSTS'					=> 'Нема порука',
	'NO_POSTS_TIME_FRAME'		=> 'Нема порука у овој теми за изабрани временски период.',
	'NO_FEED_ENABLED'			=> 'Feeds нису доступни на овом форуму.',
	'NO_FEED'					=> 'Тражени feed није доступан.',
	'NO_SUBJECT'				=> 'Нисте унели наслов',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'Изабрана позадина претраге не постоји.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'Нема подржаних начина потврде.',
	'NO_TOPIC'					=> 'Тражена тема не постоји.',
	'NO_TOPIC_FORUM'			=> 'Тема или форум више не постоји.',
	'NO_TOPICS'					=> 'Нема порука или тема у овом форуму.',
	'NO_TOPICS_TIME_FRAME'		=> 'Не постоје теме у овом форуму за изабрани период времена.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> непрочитаних порука',
	'NO_UPLOAD_FORM_FOUND'		=> 'Додавање је покренуто али није пронађен исправан образац за додавање датотеке.',
	'NO_USER'					=> 'Тражени корисник не постоји.',
	'NO_USERS'					=> 'Тражени корисници не постоје.',
	'NO_USER_SPECIFIED'			=> 'Нисте изабрали корисничко име.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'Нема порука на чекању',		// 0
		1			=> '1 порука на чекању',		// 1
		2			=> '%d порука на чекању',		// 2+
	),

	'OCCUPATION'				=> 'Занимање',
	'OFFLINE'					=> 'Није на вези',
	'ONLINE'					=> 'На вези',
	'ONLINE_BUDDIES'			=> 'Пријатељи На вези',
	'ONLINE_USERS_TOTAL'		=> 'Укупно има <strong>%d</strong> корисника На вези :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'Укупно има <strong>0</strong> корисника На вези :: ',
	'ONLINE_USER_TOTAL'			=> 'Укупно има <strong>%d</strong> корисник На вези :: ',
	'OPTIONS'					=> 'Опције',

	'PAGE_OF'				=> 'Страница <strong>%1$d</strong> од <strong>%2$d</strong>',
	'PASSWORD'				=> 'Лозинка',
	'PIXEL'					=> 'px',
	'PLAY_QUICKTIME_FILE'	=> 'Покрени Quicktime датотеку',
	'PM'					=> 'ПП',
	'POSTING_MESSAGE'		=> 'Писање поруке у %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Писање приватне поруке',
	'POST'					=> 'Порука',
	'POST_ANNOUNCEMENT'		=> 'Саопштење',
	'POST_STICKY'			=> 'Лепљива',
	'POSTED'				=> 'Послато',
	'POSTED_IN_FORUM'		=> 'у',
	'POSTED_ON_DATE'		=> 'послата',
	'POSTS'					=> 'Поруке',
	'POSTS_UNAPPROVED'		=> 'Бар једна порука у овој теми није одобрена.',
	'POST_BY_AUTHOR'		=> 'од',
	'POST_BY_FOE'			=> 'Ову поруку је написао <strong>%1$s</strong> који је тренутно на Вашем списку за игнорисање. %2$sПрикажи ову поруку%3$s.',
	'POST_DAY'				=> '%.2f порука дневно',
	'POST_DETAILS'			=> 'Детаљи поруке',
	'POST_NEW_TOPIC'		=> 'Пошаљи нову тему',
	'POST_PCT'				=> '%.2f%% од свих порука',
	'POST_PCT_ACTIVE'		=> '%.2f%% од корисникових порука',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% од Ваших порука',
	'POST_REPLY'			=> 'Пошаљи одговор',
	'POST_REPORTED'			=> 'Кликните за преглед пријаве',
	'POST_SUBJECT'			=> 'Наслов поруке',
	'POST_TIME'				=> 'Време поруке',
	'POST_TOPIC'			=> 'Пошаљи нову тему',
	'POST_UNAPPROVED'		=> 'Ова порука чека на одобрење',
	'PREVIEW'				=> 'Преглед',
	'PREVIOUS'				=> 'Претходни',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Претходни',
	'PRIVACY'				=> 'Полиса приватности',
	'PRIVATE_MESSAGE'		=> 'Приватна порука',
	'PRIVATE_MESSAGES'		=> 'Приватне поруке',
	'PRIVATE_MESSAGING'		=> 'Приватне поруке',
	'PROFILE'				=> 'Корисничка Контролна Плоча',

	'READING_FORUM'				=> 'Преглед тема у %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Читање општег саопштења',
	'READING_LINK'				=> 'Пратећа веза форума %s',
	'READING_TOPIC'				=> 'Читање теме у %s',
	'READ_PROFILE'				=> 'Профил',
	'REASON'					=> 'Резлог',
	'RECORD_ONLINE_USERS'		=> 'Највише корисника На вези било је <strong>%1$s</strong> дана %2$s',
	'REDIRECT'					=> 'Преусмери',
	'REDIRECTS'					=> 'Укупно преусмерења',
	'REGISTER'					=> 'Региструј се',
	'REGISTERED_USERS'			=> 'Регистрованих корисника:',
	'REG_USERS_ONLINE'			=> 'Има %d регистрованих корисника и ',
	'REG_USERS_TOTAL'			=> '%d регистрованих, ',
	'REG_USERS_TOTAL_AND'		=> '%d регистрованих и ',
	'REG_USERS_ZERO_ONLINE'		=> 'Има 0 регистрованих корисника и ',
	'REG_USERS_ZERO_TOTAL'		=> '0 регистрованих, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> '0 регистрованих и ',
	'REG_USER_ONLINE'			=> 'Има %d регистровани корисник и ',
	'REG_USER_TOTAL'			=> '%d регистрованих, ',
	'REG_USER_TOTAL_AND'		=> '%d регистрованих и ',
	'REMOVE'					=> 'Уклони',
	'REMOVE_INSTALL'			=> 'Молимо Вас да обришете, померите или преименујете install фасциклу пре него што почнете да користите форум. Ако је ова фасцикла још увек присутна, само ће Админ Контролна Плоча (АКП) бити доступна.',
	'REPLIES'					=> 'Одговора',
	'REPLY_WITH_QUOTE'			=> 'Одговори са цитатом',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Одговор на Опште саопштење',
	'REPLYING_MESSAGE'			=> 'Одговор на поруку у %s',
	'REPORT_BY'					=> 'Пријава од',
	'REPORT_POST'				=> 'Пријави ову поруку',
	'REPORTING_POST'			=> 'Пријава поруке',
	'RESEND_ACTIVATION'			=> 'Поново пошаљи активациони мејл',
	'RESET'						=> 'Испочетка',
	'RESTORE_PERMISSIONS'		=> 'Поврати дозволе',
	'RETURN_INDEX'				=> '%sПовратак на почетну страницу%s',
	'RETURN_FORUM'				=> '%sПовратак на последњи посећени форум%s',
	'RETURN_PAGE'				=> '%sПовратак на претходну страницу%s',
	'RETURN_TOPIC'				=> '%sПовратак на последњу посећену тему%s',
	'RETURN_TO'					=> 'Повратак на',
	'FEED'						=> 'Feed',
	'FEED_NEWS'					=> 'News',
	'FEED_TOPICS_ACTIVE'		=> 'Активне теме',
	'FEED_TOPICS_NEW'			=> 'Нове теме',
	'RULES_ATTACH_CAN'			=> 'Ви <strong>можете</strong> слати прилоге у овај форум',
	'RULES_ATTACH_CANNOT'		=> '<strong>Не можете</strong> слати прилоге у овај форум',
	'RULES_DELETE_CAN'			=> '<strong>Можете</strong> брисати Ваше поруке у овом форуму',
	'RULES_DELETE_CANNOT'		=> '<strong>Не можете</strong> брисати Ваше поруке у овом форуму',
	'RULES_DOWNLOAD_CAN'		=> '<strong>Можете</strong> преузимати прилоге из овог форума',
	'RULES_DOWNLOAD_CANNOT'		=> '<strong>Не можете</strong> преузимати прилоге из овог форума',
	'RULES_EDIT_CAN'			=> '<strong>Можете</strong> учитавати Ваше поруке у овом форуму',
	'RULES_EDIT_CANNOT'			=> '<strong>Не можете</strong> учитавати Ваше поруке у овом форуму',
	'RULES_LOCK_CAN'			=> '<strong>Можете</strong> закључати Ваше теме у овом форуму',
	'RULES_LOCK_CANNOT'			=> '<strong>Не можете</strong> закључати Ваше теме у овом форуму',
	'RULES_POST_CAN'			=> '<strong>Можете</strong> слати нове теме у овај форум',
	'RULES_POST_CANNOT'			=> '<strong>Не можете</strong> слати нове теме у овај форум',
	'RULES_REPLY_CAN'			=> '<strong>Можете</strong> одговарати на теме у овом форуму',
	'RULES_REPLY_CANNOT'		=> '<strong>Не можете</strong> одговарати на теме у овом форуму',
	'RULES_VOTE_CAN'			=> '<strong>Можете</strong> гласати у овом форуму',
	'RULES_VOTE_CANNOT'			=> '<strong>Не можете</strong> гласати у овом форуму',

	'SEARCH'					=> 'Претрага',
	'SEARCH_MINI'				=> 'Претрага…',
	'SEARCH_ADV'				=> 'Напредна претрага',
	'SEARCH_ADV_EXPLAIN'		=> 'Преглед напредних могућности претраге',
	'SEARCH_KEYWORDS'			=> 'Претрага по кључној речи',
	'SEARCHING_FORUMS'			=> 'Претрага форума',
	'SEARCH_ACTIVE_TOPICS'		=> 'Преглед активних тема',
	'SEARCH_FOR'				=> 'Пронађи',
	'SEARCH_FORUM'				=> 'Претражи овај форум…',
	'SEARCH_NEW'				=> 'Преглед нових порука',
	'SEARCH_POSTS_BY'			=> 'Претрага порука по',
	'SEARCH_SELF'				=> 'Преглед Ваших порука',
	'SEARCH_TOPIC'				=> 'Претражи ову тему…',
	'SEARCH_UNANSWERED'			=> 'Преглед неодговорених порука',
	'SEARCH_UNREAD'				=> 'Преглед непрочитаних порука',
	'SECONDS'					=> 'Секунди',
	'SELECT'					=> 'Изаберите',
	'SELECT_ALL_CODE'			=> 'Изаберите све',
	'SELECT_DESTINATION_FORUM'	=> 'Молимо изаберите одредишни форум',
	'SELECT_FORUM'				=> 'Изаберите форум',
	'SEND_EMAIL'				=> 'Мејл',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'Мејл',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'Пошаљи приватну поруку',
	'SETTINGS'					=> 'Поставке',
	'SIGNATURE'					=> 'Потпис',
	'SKIP'						=> 'Прескочи на садржај',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP сервер не подржава потврду.',
	'SORRY_AUTH_READ'			=> 'Нисте овлашћени да читате овај форум.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'Нисте овлашћени да преузмете овај прилог.',
	'SORT_BY'					=> 'Поређај по',
	'SORT_JOINED'				=> 'Придружен',
	'SORT_LOCATION'				=> 'Место',
	'SORT_RANK'					=> 'Чин',
	'SORT_POSTS'				=> 'Поруке',
	'SORT_TOPIC_TITLE'			=> 'Наслов теме',
	'SORT_USERNAME'				=> 'Корисничко име',
	'SPLIT_TOPIC'				=> 'Раздвој тему',
	'SQL_ERROR_OCCURRED'		=> 'Појавила се грешка у SQL-у приликом добављања ове странице. Молимо Вас да се повежете са %sАдминистратором форума%s уколико ова сметња остане.',
	'STATISTICS'				=> 'Статистике',
	'START_WATCHING_FORUM'		=> 'Прати форум',
	'START_WATCHING_TOPIC'		=> 'Прати тему',
	'STOP_WATCHING_FORUM'		=> 'Прекини праћење форума',
	'STOP_WATCHING_TOPIC'		=> 'Прекини праћење теме',
	'SUBFORUM'					=> 'Подфорум',
	'SUBFORUMS'					=> 'Подфоруми',
	'SUBJECT'					=> 'Наслов',
	'SUBMIT'					=> 'Прихвати',

	'TERMS_USE'			=> 'Услови коришћења',
	'TEST_CONNECTION'	=> 'Проба повезивања',
	'THE_TEAM'			=> 'Тим',
	'TIME'				=> 'Време',

	'TOO_LONG'						=> 'Вредност коју сте унели је предугачка.',

	'TOO_LONG_AIM'					=> 'Приказано име које сте унели је предугачко.',
	'TOO_LONG_CONFIRM_CODE'			=> 'Код за потврду који сте унели је предугачак.',
	'TOO_LONG_DATEFORMAT'			=> 'Облик датума који сте унели је предугачак.',
	'TOO_LONG_ICQ'					=> 'ICQ број који сте унели је предугачак.',
	'TOO_LONG_INTERESTS'			=> 'Занимања која сте унели су предугачка.',
	'TOO_LONG_JABBER'				=> 'Име Jabber налога који сте унели је предугачко.',
	'TOO_LONG_LOCATION'				=> 'Место које сте унели је предугачко.',
	'TOO_LONG_MSN'					=> 'MSNM/WLM име који сте унели је предугачко.',
	'TOO_LONG_NEW_PASSWORD'			=> 'Лозинка коју сте унели је предугачка.',
	'TOO_LONG_OCCUPATION'			=> 'Занимање које сте унели је предугачко.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'Потврда лозинке коју сте унели је предугачка.',
	'TOO_LONG_USER_PASSWORD'		=> 'Лозинка коју сте унели је предугачка.',
	'TOO_LONG_USERNAME'				=> 'Корисничко име које сте унели је предугачко.',
	'TOO_LONG_EMAIL'				=> 'Мејл адреса коју сте унели је предугачка.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'Потврда мејл адресе коју сте унели је предугачка.',
	'TOO_LONG_WEBSITE'				=> 'Адреса веб странице коју сте унели је предугачка.',
	'TOO_LONG_YIM'					=> 'Yahoo! Messenger име које сте унели је предугачко.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'Покушали сте да гласате за превише понуда.',

	'TOO_SHORT'						=> 'Вредност коју сте унели је прекратка.',

	'TOO_SHORT_AIM'					=> 'Приказно име које сте унели је прекратко.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'Код за потврду који сте унели је прекратак.',
	'TOO_SHORT_DATEFORMAT'			=> 'Облик датума који сте унели је прекратак.',
	'TOO_SHORT_ICQ'					=> 'ICQ број који сте унели је прекратак.',
	'TOO_SHORT_INTERESTS'			=> 'Занимања која сте унели су прекратка.',
	'TOO_SHORT_JABBER'				=> 'Име Jabber налога које сте унели је прекратко.',
	'TOO_SHORT_LOCATION'			=> 'Место који сте унели је прекратко.',
	'TOO_SHORT_MSN'					=> 'MSNM/WLM име које сте унели је прекратко.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'Лозинка коју сте унели је прекратка.',
	'TOO_SHORT_OCCUPATION'			=> 'Занимање које сте унели је прекратко.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'Потврда лозинке коју сте унели је прекратка.',
	'TOO_SHORT_USER_PASSWORD'		=> 'Лозинка коју сте унели је прекратка.',
	'TOO_SHORT_USERNAME'			=> 'Корисничко име које сте унели је прекратко.',
	'TOO_SHORT_EMAIL'				=> 'Мејл адреса коју сте унели је прекратка.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'Потврда мејл адресе коју сте унели је прекратка.',
	'TOO_SHORT_WEBSITE'				=> 'Адреса веб странице коју сте унели је прекратка.',
	'TOO_SHORT_YIM'					=> 'Yahoo! Messenger име које сте унели је прекратко.',

	'TOPIC'				=> 'Тема',
	'TOPICS'			=> 'Теме',
	'TOPICS_UNAPPROVED'	=> 'Бар једна тема у овом форуму није одобрена.',
	'TOPIC_ICON'		=> 'Иконица теме',
	'TOPIC_LOCKED'		=> 'Ова тема је закључана, не можете да учитавате поруке нити да одговарате.',
	'TOPIC_LOCKED_SHORT'=> 'Закључана тема',
	'TOPIC_MOVED'		=> 'Померена тема',
	'TOPIC_REVIEW'		=> 'Преглед теме',
	'TOPIC_TITLE'		=> 'Наслов теме',
	'TOPIC_UNAPPROVED'	=> 'Ова тема још увек није одобрена',
	'TOTAL_ATTACHMENTS'	=> 'Прилог(ози)',
	'TOTAL_LOG'			=> '1 запис',
	'TOTAL_LOGS'		=> '%d записа',
	'TOTAL_NO_PM'		=> 'Укупно 0 приватних порука',
	'TOTAL_PM'			=> 'Укупно 1 приватних порука',
	'TOTAL_PMS'			=> 'Укупно %d приватних порука',
	'TOTAL_POSTS'		=> 'Укупно порука',
	'TOTAL_POSTS_OTHER'	=> 'Укупно <strong>%d</strong> порука',
	'TOTAL_POSTS_ZERO'	=> 'Укупно <strong>0</strong> порука',
	'TOPIC_REPORTED'	=> 'Ова тема је пријављена',
	'TOTAL_TOPICS_OTHER'=> 'Укупно <strong>%d</strong> тема',
	'TOTAL_TOPICS_ZERO'	=> 'Укупно <strong>0</strong> тема',
	'TOTAL_USERS_OTHER'	=> 'Укупно <strong>%d</strong> чланова',
	'TOTAL_USERS_ZERO'	=> 'Укупно <strong>0</strong> чланова',
	'TRACKED_PHP_ERROR'	=> 'Прађене PHP грешке: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'Није било могуће одредити величину слике.',
	'UNABLE_TO_DELIVER_FILE'=> 'Не могу да испоручим датотеку.',
	'UNKNOWN_BROWSER'		=> 'Непознат прегледач',
	'UNMARK_ALL'			=> 'Одзначи све',
	'UNREAD_MESSAGES'		=> 'Непрочитане поруке',
	'UNREAD_PM'				=> '<strong>%d</strong> непрочитана порука',
	'UNREAD_PMS'			=> '<strong>%d</strong> непрочитаних порука',
	'UNWATCHED_FORUMS'			=> 'Више не пратите изабране форуме.',
	'UNWATCHED_TOPICS'			=> 'Више не пратите изабране теме.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'Више не пратите изабрано.',
	'UPDATE'				=> 'Ажурирај',
	'UPLOAD_IN_PROGRESS'	=> 'Додавање је тренутно у току.',
	'URL_REDIRECT'			=> 'Уколико Ваш прегледач не подржава мета преусмеравање %sмолимо Вас да кликнете ОВДЕ како бисте били преусмерени%s.',
	'USERGROUPS'			=> 'Корисничке групе',
	'USERNAME'				=> 'Корисничко име',
	'USERNAMES'				=> 'Корисничка имена',
	'USER_AVATAR'			=> 'Корисников грб',
	'USER_CANNOT_READ'		=> 'Не можете читати поруке у овом форуму.',
	'USER_POST'				=> '%d порука',
	'USER_POSTS'			=> '%d порука',
	'USERS'					=> 'Корисници',
	'USE_PERMISSIONS'		=> 'Испробавање дозвола корисника',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'Жао нам је, али немате дозволу да користите ову могућност. Можда сте само регистровани овде а треба да учествујете више да бисте могли да користите ову могућност.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Прегледане',
	'VIEWING_FAQ'				=> 'Преглед ЧПП',
	'VIEWING_MEMBERS'			=> 'Преглед чланових детаља',
	'VIEWING_ONLINE'			=> 'Преглед Ко је на вези',
	'VIEWING_MCP'				=> 'Преглед контролне плоче уредника',
	'VIEWING_MEMBER_PROFILE'	=> 'Преглед профила члана',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Преглед приватних порука',
	'VIEWING_REGISTER'			=> 'Регистровање налога',
	'VIEWING_UCP'				=> 'Преглед Корисничке Контролне Плоче',
	'VIEWS'						=> 'Прегледа',
	'VIEW_BOOKMARKS'			=> 'Преглед белешки',
	'VIEW_FORUM_LOGS'			=> 'Преглед записа',
	'VIEW_LATEST_POST'			=> 'Преглед задње поруке',
	'VIEW_NEWEST_POST'			=> 'Преглед прве непрочитане поруке',
	'VIEW_NOTES'				=> 'Преглед белешки корисника',
	'VIEW_ONLINE_TIME'			=> 'основано на корисницима активним у последњих %d минута',
	'VIEW_ONLINE_TIMES'			=> 'основано на корисницима активним у последњих %d минута',
	'VIEW_TOPIC'				=> 'Преглед теме',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Саопштење: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Опште саопштење: ',
	'VIEW_TOPIC_LOCKED'			=> 'Закључана: ',
	'VIEW_TOPIC_LOGS'			=> 'Преглед записа',
	'VIEW_TOPIC_MOVED'			=> 'Померена: ',
	'VIEW_TOPIC_POLL'			=> 'Гласање: ',
	'VIEW_TOPIC_STICKY'			=> 'Лепљива: ',
	'VISIT_WEBSITE'				=> 'Посети веб страницу',

	'WARNINGS'			=> 'Опомене',
	'WARN_USER'			=> 'Опомени корисника',
	'WELCOME_SUBJECT'	=> 'Добро дошли на %s форуме',
	'WEBSITE'			=> 'Веб страница',
	'WHOIS'				=> 'Ко је',
	'WHO_IS_ONLINE'		=> 'Ко је на вези',
	'WRONG_PASSWORD'	=> 'Унели сте неисправну лозинку.',

	'WRONG_DATA_ICQ'			=> 'Број који сте унели није исправан ICQ број.',
	'WRONG_DATA_JABBER'			=> 'Име које сте унели није исправно име Jabber налога.',
	'WRONG_DATA_LANG'			=> 'Језик који сте изабрали није исправан.',
	'WRONG_DATA_WEBSITE'		=> 'Адреса веб странице мора бити исправан URL, укључујући и протокол. На пример http://www.medicinari.com/.',
	'WROTE'						=> 'пише',

	'YEAR'				=> 'Година',
	'YEAR_MONTH_DAY'	=> '(ГГГГ-ММ-ДД)',
	'YES'				=> 'Да',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'Последња посета: %s',
	'YOU_NEW_PM'		=> 'Нова приватна порука Вас чека у Вашем сандучету.',
	'YOU_NEW_PMS'		=> 'Нове приватне поруке Вас чекају у Вашем сандучету.',
	'YOU_NO_NEW_PM'		=> 'Нема нових приватних порука.',

	'datetime'			=> array(
		'TODAY'		=> 'Данас',
		'TOMORROW'	=> 'Сутра',
		'YESTERDAY'	=> 'Јуче',
		'AGO'		=> array(
			0		=> 'пре мање од минута',
			1		=> 'пре %d минут',
			2		=> 'пре %d минута',
			60		=> 'пре 1 сат',
		),

		'Sunday'	=> 'Недеља',
		'Monday'	=> 'Понедељак',
		'Tuesday'	=> 'Уторак',
		'Wednesday'	=> 'Среда',
		'Thursday'	=> 'Четвртак',
		'Friday'	=> 'Петак',
		'Saturday'	=> 'Субота',

		'Sun'		=> 'Нед',
		'Mon'		=> 'Пон',
		'Tue'		=> 'Уто',
		'Wed'		=> 'Сре',
		'Thu'		=> 'Чет',
		'Fri'		=> 'Пет',
		'Sat'		=> 'Суб',

		'January'	=> 'Јануар',
		'February'	=> 'Фебруар',
		'March'		=> 'Март',
		'April'		=> 'Април',
		'May'		=> 'Мај',
		'June'		=> 'Јун',
		'July'		=> 'Јул',
		'August'	=> 'Август',
		'September' => 'Септембар',
		'October'	=> 'Октобар',
		'November'	=> 'Новембар',
		'December'	=> 'Децембар',

		'Jan'		=> 'Јан',
		'Feb'		=> 'Феб',
		'Mar'		=> 'Мар',
		'Apr'		=> 'Апр',
		'May_short'	=> 'Мај',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Јун',
		'Jul'		=> 'Јул',
		'Aug'		=> 'Авг',
		'Sep'		=> 'Сеп',
		'Oct'		=> 'Окт',
		'Nov'		=> 'Нов',
		'Dec'		=> 'Дец',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 сати',
		'-11'	=> 'UTC - 11 сати',
		'-10'	=> 'UTC - 10 сати',
		'-9.5'	=> 'UTC - 9:30 сати',
		'-9'	=> 'UTC - 9 сати',
		'-8'	=> 'UTC - 8 сати',
		'-7'	=> 'UTC - 7 сати',
		'-6'	=> 'UTC - 6 сати',
		'-5'	=> 'UTC - 5 сати',
		'-4.5'	=> 'UTC - 4:30 сати',
		'-4'	=> 'UTC - 4 сата',
		'-3.5'	=> 'UTC - 3:30 сата',
		'-3'	=> 'UTC - 3 сата',
		'-2'	=> 'UTC - 2 сата',
		'-1'	=> 'UTC - 1 сат',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 сат',
		'2'		=> 'UTC + 2 сата',
		'3'		=> 'UTC + 3 сата',
		'3.5'	=> 'UTC + 3:30 сата',
		'4'		=> 'UTC + 4 сата',
		'4.5'	=> 'UTC + 4:30 сати',
		'5'		=> 'UTC + 5 сати',
		'5.5'	=> 'UTC + 5:30 сати',
		'5.75'	=> 'UTC + 5:45 сати',
		'6'		=> 'UTC + 6 сати',
		'6.5'	=> 'UTC + 6:30 сати',
		'7'		=> 'UTC + 7 сати',
		'8'		=> 'UTC + 8 сати',
		'8.75'	=> 'UTC + 8:45 сати',
		'9'		=> 'UTC + 9 сати',
		'9.5'	=> 'UTC + 9:30 сати',
		'10'	=> 'UTC + 10 сати',
		'10.5'	=> 'UTC + 10:30 сати',
		'11'	=> 'UTC + 11 сати',
		'11.5'	=> 'UTC + 11:30 сати',
		'12'	=> 'UTC + 12 сати',
		'12.75'	=> 'UTC + 12:45 сати',
		'13'	=> 'UTC + 13 сати',
		'14'	=> 'UTC + 14 сати',
		'dst'	=> '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Бекер',
		'-11'	=> '[UTC - 11] Самоа',
		'-10'	=> '[UTC - 10] Хаваји-Алеути, Кукова острва',
		'-9.5'	=> '[UTC - 9:30] Маркизова острва',
		'-9'	=> '[UTC - 9] Аљаска, Гамбијер острва',
		'-8'	=> '[UTC - 8] Пацифичко време',
		'-7'	=> '[UTC - 7] Планинско време',
		'-6'	=> '[UTC - 6] Централно време',
		'-5'	=> '[UTC - 5] Источно време',
		'-4.5'	=> '[UTC - 4:30] Венецуеланско стандардно време',
		'-4'	=> '[UTC - 4] Атлантско време',
		'-3.5'	=> '[UTC - 3:30] Њуфаундленд',
		'-3'	=> '[UTC - 3] Амазон, Централни Гренланд',
		'-2'	=> '[UTC - 2] Фернандо де Нороња, Јужна Џорџија &amp; Јужна сендвич острва',
		'-1'	=> '[UTC - 1] Азори, Капе верде острва, Источни Гренланд',
		'0'		=> '[UTC] Западна Европа, Гринич',
		'1'		=> '[UTC + 1] Београд, Централна Европа, Западна Африка',
		'2'		=> '[UTC + 2] Источна Европа, Централна Африка',
		'3'		=> '[UTC + 3] Москва, Источна Африка',
		'3.5'	=> '[UTC + 3:30] Иран',
		'4'		=> '[UTC + 4] Заливско време, Самара',
		'4.5'	=> '[UTC + 4:30] Афганистан',
		'5'		=> '[UTC + 5] Екатеринбург, Пакистан',
		'5.5'	=> '[UTC + 5:30] Идија, Шри Ланка',
		'5.75'	=> '[UTC + 5:45] Непал',
		'6'		=> '[UTC + 6] Бангладеш, Бутан, Новосибирск',
		'6.5'	=> '[UTC + 6:30] Кокос, Мијанмар',
		'7'		=> '[UTC + 7] Краснојарск, Индокина',
		'8'		=> '[UTC + 8] Кина, Западно Аустралијско, Иркутск',
		'8.75'	=> '[UTC + 8:45] Југоисточно западно аустралијско',
		'9'		=> '[UTC + 9] Јапан, Кореја, Чита',
		'9.5'	=> '[UTC + 9:30] Централна Аустралија',
		'10'	=> '[UTC + 10] Владивосток, Источна Аустралија',
		'10.5'	=> '[UTC + 10:30] Лорд Хов',
		'11'	=> '[UTC + 11] Соломонска острва, Магадан',
		'11.5'	=> '[UTC + 11:30] Норфолк острва',
		'12'	=> '[UTC + 12] Камчатка, Фиџи, Нови Зеланд',
		'12.75'	=> '[UTC + 12:45] Чатам острва',
		'13'	=> '[UTC + 13] Тонга, Феникс',
		'14'	=> '[UTC + 14] Линијска острва',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> '|d M Y|, H:i', // Mon Jan 01, 2007 1:37 pm

));

?>