/* serverdlg.c
   This file is part of "Pharmacy: A GNOME CVS front-end"
   Copyright 1998 Reklaw (N. Adam Walker)
   "Pharmacy" is released under the GPL
   See the LICENCE for more details.
 */

/* Includes */
#include <gnome.h>

#include "location.h"
#include "pharmacy.h"

#include "serverdlg.h"
#include <assert.h>

/* Strruct */
static GtkWidget *pgDlg = NULL;
static GtkWidget *pcList = NULL;

  /*Buttons */
static GtkWidget *pbAdd = NULL;
static GtkWidget *pbRemove = NULL;
static GtkWidget *pbEdit = NULL;

 /* Entry Boxes & Labels */
#define R_NAME 0
#define R_SERVER 1
#define R_WORK_DIR 2
static GtkWidget *apEntries[] =
{NULL, NULL, NULL};
static GtkWidget *apLabels[] =
{NULL, NULL, NULL};


gint nListRowSelected = -1;


typedef struct _ListTag ListTag;
struct _ListTag
  {
    LocationData *pOrg;
    LocationData *pEdited;
  };

/* Declare static callback here */
void
add_clicked (GtkButton * button)
{
  LocationData *pLoc = NULL;
  gint row = 0;
  gchar *text[] =
  {NULL, NULL, NULL};

  text[0] = g_strdup (gtk_entry_get_text (GTK_ENTRY (apEntries[R_NAME])));

  pLoc =
    locationdata_new_with_values (text[0],
				  gtk_entry_get_text (
					   GTK_ENTRY (apEntries[R_SERVER])),
		    gtk_entry_get_text (GTK_ENTRY (apEntries[R_WORK_DIR])));

  row = gtk_clist_append (GTK_CLIST (pcList), text);
  gtk_clist_set_row_data (GTK_CLIST (pcList), row, pLoc);
}

void
select_row_callback (GtkWidget * widget,
		     gint row,
		     gint column,
		     GdkEventButton * event,
		     gpointer data)
{
  LocationData *pLoc = (LocationData *) gtk_clist_get_row_data (GTK_CLIST (widget), row);

  nListRowSelected = row;
  gtk_widget_set_sensitive (pbRemove, TRUE);
  gtk_widget_set_sensitive (pbEdit, TRUE);

  if (pLoc)
    {
      /* Put data in the edit area */
      gtk_entry_set_text (GTK_ENTRY (apEntries[R_SERVER]),
			  locationdata_get_server (pLoc));
      gtk_entry_set_text (GTK_ENTRY (apEntries[R_WORK_DIR]),
			  locationdata_get_workdir (pLoc));
      gtk_entry_set_text (GTK_ENTRY (apEntries[R_NAME]),
			  locationdata_get_name (pLoc));
    }
}

void
unselect_row_callback (GtkWidget * widget,
		       gint row,
		       gint column,
		       GdkEventButton * event,
		       gpointer data)
{
  nListRowSelected = -1;
  gtk_widget_set_sensitive (pbRemove, FALSE);
  gtk_widget_set_sensitive (pbEdit, FALSE);
}


void
remove_clicked (GtkButton * button)
{
  if (nListRowSelected != -1)
    {
      g_debug_message ("Row remove");
      locationdata_mark (gtk_clist_get_row_data (GTK_CLIST (pcList),
						 nListRowSelected));
      gtk_clist_remove (GTK_CLIST (pcList), nListRowSelected);
    }
}

void
edit_clicked (GtkButton * button)

{
  LocationData *pLoc = NULL;
  gchar *text[] =
  {NULL, NULL, NULL};

  if (nListRowSelected != -1)
    {
      pLoc = (LocationData *) gtk_clist_get_row_data (GTK_CLIST (pcList),
						      nListRowSelected);
      text[0] = g_strdup (gtk_entry_get_text (GTK_ENTRY (apEntries[R_NAME])));

      locationdata_set_values (pLoc, text[0],
			       gtk_entry_get_text (
					   GTK_ENTRY (apEntries[R_SERVER])),
		    gtk_entry_get_text (GTK_ENTRY (apEntries[R_WORK_DIR])));

      gtk_clist_set_text (GTK_CLIST (pcList), nListRowSelected, 0, text[0]);
      gtk_clist_set_row_data (GTK_CLIST (pcList), nListRowSelected, pLoc);
    }
}

static gchar *titles[] =
{
  _ ("Name")
};

static GtkWidget *
make_button_under_list (GtkWidget * pBox, gchar * pgcChar,
			void *pFunc)
{
  GtkWidget *pWidget = gtk_button_new_with_label (pgcChar);
  gtk_box_pack_start (GTK_BOX (pBox), pWidget, FALSE, FALSE, 0);
  gtk_widget_show (pWidget);
  if (pFunc)
    {
      gtk_signal_connect (GTK_OBJECT (pWidget), _ ("clicked"), GTK_SIGNAL_FUNC (pFunc), NULL);
    }

  gtk_widget_set_sensitive (pWidget, FALSE);
  return pWidget;
}

/* Build The Servers Dialog */
static void
server_dlg_build ()
{
  /* assert(pServerDlg != NULL); */
  GtkWidget *phBox = NULL;
  GtkWidget *pvListBox = NULL;
  GtkWidget *pButtonBox = NULL;
  GtkWidget *pServerForm = NULL;
  GtkWidget *pTemp = NULL;
  GtkWidget *pLabel = NULL;

  pgDlg = gnome_dialog_new (_ ("Servers"), GNOME_STOCK_BUTTON_OK,
			    GNOME_STOCK_BUTTON_CANCEL, NULL);

  gtk_widget_set_usize (pgDlg, 500, 400);

  phBox = gtk_hbox_new (0, 0);
  pvListBox = gtk_vbox_new (0, 0);
  pButtonBox = gtk_hbutton_box_new ();

  gtk_box_pack_start (GTK_BOX (GNOME_DIALOG (pgDlg)->vbox),
		      phBox, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (phBox), pvListBox, TRUE, TRUE, 0);
  pcList = gtk_clist_new_with_titles (1, titles);
  gtk_box_pack_start (GTK_BOX (pvListBox), util_contain_in_scrolled (pcList), TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (pcList), "select_row", select_row_callback, NULL);
  gtk_signal_connect (GTK_OBJECT (pcList), "unselect_row", unselect_row_callback, NULL);

  gtk_box_pack_start (GTK_BOX (pvListBox), pButtonBox, FALSE, FALSE, 0);

  /* Buttons under List */
  pbAdd = make_button_under_list (pButtonBox, _ ("Add"), add_clicked);
  gtk_widget_set_sensitive (pbAdd, TRUE);
  pbRemove = make_button_under_list (pButtonBox, _ ("Remove"), remove_clicked);
  pbEdit = make_button_under_list (pButtonBox, _ ("Edit"), edit_clicked);

  /* Server Form */
  pServerForm = gtk_vbox_new (0, 0);
  gtk_box_pack_start (GTK_BOX (phBox), pServerForm, FALSE, FALSE, 0);

  /*Name */
  pTemp = gtk_hbox_new (0, 0);
  apEntries[R_NAME] = gtk_entry_new_with_max_length (255);
  apLabels[R_NAME] = gtk_label_new (_ ("Name:"));
  gtk_box_pack_start (GTK_BOX (pTemp), apLabels[R_NAME], FALSE, FALSE, 0);
  gtk_widget_show (apLabels[R_NAME]);
  gtk_box_pack_start (GTK_BOX (pTemp), apEntries[R_NAME], TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (pServerForm), pTemp, FALSE, FALSE, 0);
  gtk_widget_show (pTemp);
  gtk_widget_show (apEntries[R_NAME]);

  /* Server */
  apEntries[R_SERVER] = gtk_entry_new_with_max_length (255);
  pTemp = gtk_hbox_new (0, 0);
  apLabels[R_SERVER] = gtk_label_new (_ ("CVSROOT:"));
  gtk_box_pack_start (GTK_BOX (pTemp), apLabels[R_SERVER], FALSE, FALSE, 0);
  gtk_widget_show (apLabels[R_SERVER]);
  gtk_box_pack_start (GTK_BOX (pTemp), apEntries[R_SERVER], TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (pServerForm), pTemp, TRUE, FALSE, 0);
  gtk_widget_show (pTemp);
  gtk_widget_show (apEntries[R_SERVER]);

  /*WorkDir */
  pTemp = gtk_hbox_new (0, 0);
  apEntries[R_WORK_DIR] = gtk_entry_new_with_max_length (255);
  apLabels[R_WORK_DIR] = gtk_label_new (_ ("Working Dir:"));
  gtk_box_pack_start (GTK_BOX (pTemp), apLabels[R_WORK_DIR], FALSE, FALSE, 0);
  gtk_widget_show (apLabels[R_WORK_DIR]);
  gtk_box_pack_start (GTK_BOX (pTemp), apEntries[R_WORK_DIR], TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (pServerForm), pTemp, FALSE, FALSE, 0);
  gtk_widget_show (pTemp);
  gtk_widget_show (apEntries[R_WORK_DIR]);

  /*Space */
  pLabel = gtk_label_new ("");
  gtk_box_pack_start (GTK_BOX (pServerForm), pLabel, TRUE, TRUE, 0);
  gtk_widget_show (pLabel);

  gtk_widget_show (pcList);
  gtk_widget_show (pServerForm);
  gtk_widget_show (phBox);
  gtk_widget_show (pvListBox);
  gtk_widget_show (pButtonBox);

}

/* Menu item callback */
/* Displays the Server Dialog */
void
server_dlg_cb (GtkWidget * widget, void *data)
{
  gint nButton;
  server_dlg_build ();

  assert (pgDlg != NULL);
  /*gtk_widget_show(GTK_WIDGET(pgDlg)); */
  server_dlg_load_list (pharmacy_get_locations ());
  gnome_dialog_set_close (GNOME_DIALOG (pgDlg), FALSE);
  nButton = gnome_dialog_run (GNOME_DIALOG (pgDlg));
  if (nButton == 0)
    {
      /* Ok */
      server_dlg_save_list (pharmacy_get_locations ());
      pharmacy_rebuild_entire_dirtree ();
    }

  /* Close dialog AFTER we get the needed info */
  gnome_dialog_close (GNOME_DIALOG (pgDlg));

}

static void
load_list_cb (gpointer pData, gpointer pDontCare)
{
  LocationData *pLoc = NULL;
  gint row = 0;
  gchar *text[] =
  {NULL, NULL, NULL};

  if (pData)
    {
      text[0] = g_strdup (locationdata_get_name (pData));

      row = gtk_clist_append (GTK_CLIST (pcList), text);
      gtk_clist_set_row_data (GTK_CLIST (pcList), row, pData);
    }
}

void
server_dlg_load_list (GList * pList)
{
  assert (pList != NULL);

  g_list_foreach ((pList), (load_list_cb), NULL);
}

void
server_dlg_save_list (GList * pList)
{
  gpointer pData;
  GList *pFind;
  gint row = 0;
  assert (pList != NULL);

  locations_remove_marked (pList);

  /*  gtk_container_foreach(GTK_CONTAINER(pcList),save_list_cb,NULL); */
  while (TRUE)
    {
      pData = gtk_clist_get_row_data (GTK_CLIST (pcList), row);

      if (pData)
	{
	  pFind = g_list_find (pList, pData);
	  if (pFind)
	    {
	      g_debug_message ("Found it");
	    }
	  else
	    {
	      g_debug_message ("Nope");
	      g_list_append (pList, pData);
	    }
	}
      else
	{
	  break;
	}
      row++;
    }

}
