# $Progeny: auto_partition_base.py,v 1.13 2002/02/18 22:19:35 epg Exp $

import pgi.common

from pgi.common import ROOT_MB, SWAP_MB, TRUE, FALSE

def calc_partitions(freespace, parts):
    """Returns a list of quadruples with mount point, fstype, size in
    MB, and whether the partition must be primary.
    """

    if not parts:
        return None

    total_needed = 0
    for part in parts:
        total_needed = total_needed + part[2]

    pgi.common.msg("auto_partition_base needs %d and %d is available... \n"
                   % (total_needed, freespace))

    if freespace < total_needed:
        pgi.common.msg("It is not enough.\n")
        return None
    pgi.common.msg("Works for me.\n")

    # Since we have enough, go ahead and try to fill up the rest of
    # the free space rather than just using the minimum.
    rootsize = freespace - total_needed + ROOT_MB
    pgi.common.msg("Using %d for /.\n" % (rootsize,))

    needed_parts = [("/", "Linux ext2", rootsize, FALSE)]
    for part in parts:
        if part[0] != "/":
            needed_parts.append(part)

    return needed_parts

def get_standard_partitions():
    parts = []
    parts.append(("/", "Linux ext2", ROOT_MB, FALSE))
    parts.append(("swap", "Linux swap", SWAP_MB, FALSE))

    return parts
