<!DOCTYPE style-sheet PUBLIC "-//James Clark//DTD DSSSL Style Sheet//EN" [
<!ENTITY % html "IGNORE">
<![%html;[
<!ENTITY % print "IGNORE">
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook HTML Stylesheet//EN" CDATA dsssl>
]]>
<!ENTITY % print "INCLUDE">
<![%print;[
<!ENTITY docbook.dsl PUBLIC "-//Norman Walsh//DOCUMENT DocBook Print Stylesheet//EN" CDATA dsssl>
]]>
]>

<style-sheet>

<style-specification id="print" use="docbook">
<style-specification-body> 

;; ==============================
;; customize the print stylesheet
;; ==============================

(declare-characteristic preserve-sdata?
  ;; this is necessary because right now jadetex does not understand
  ;; symbolic entities, whereas things work well with numeric entities.
  "UNREGISTERED::James Clark//Characteristic::preserve-sdata?"
  #f)

(define %generate-article-toc%
  ;; Should a Table of Contents be produced for Articles?
  #t)

(define (toc-depth nd)
  2)

(define %generate-article-titlepage-on-separate-page%
  ;; Should the article title page be on a separate page?
  #t)

(define %section-autolabel%
  ;; Are sections enumerated?
  #t)

(define %footnote-ulinks%
  ;; Generate footnotes for ULinks?
  #f)

(define %bop-footnotes%
  ;; Make "bottom-of-page" footnotes?
  #f)

(define %body-start-indent%
  ;; Default indent of body text
  0pi)

(define %para-indent-firstpara%
  ;; First line start-indent for the first paragraph
  0pt)

(define %para-indent%
  ;; First line start-indent for paragraphs (other than the first)
  0pt)

(define %block-start-indent%
  ;; Extra start-indent for block-elements
  0pt)

;; For now, turning this on is bad, because long tables float right
;; off the end of the page. It looks like one could customize which
;; types of objects float.
(define formal-object-float
  ;; Do formal objects float?
  #f)

(define %hyphenation%
  ;; Allow automatic hyphenation?
  #t)

(define %admon-graphics%
  ;; Use graphics in admonitions?
  #f)

(define (article-titlepage-recto-elements)
  ;; elements on an article's titlepage
  ;; note: added othercredit to the default list
  (list (normalize "title")
        (normalize "subtitle")
        (normalize "authorgroup")
        (normalize "author")
        (normalize "othercredit")
        (normalize "releaseinfo")
        (normalize "copyright")
        (normalize "pubdate")
        (normalize "revhistory")
        (normalize "abstract")))

;; This next block should go away entirely when the upstream DocBook
;; maintainers accept my patch, and when Debian imports it.
;;
;; Until that point in time, adding the copyright to an article's
;; title page is pretty ugly in printed output; the copyright is much
;; too close to the list of authors.

(mode article-titlepage-recto-mode
  (element abbrev
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element abstract
    (make display-group
      use: article-titlepage-verso-style ;; EVEN THOUGH IT'S RECTO!
      quadding: 'start
      start-indent: (+ (inherited-start-indent) (/ %body-width% 24))
      end-indent: (+ (inherited-end-indent) (/ %body-width% 24))
      ($semiformal-object$)))

  (element (abstract title) (empty-sosofo))

  (element address 
    (make display-group
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (with-mode titlepage-address-mode 
	($linespecific-display$ %indent-address-lines% %number-address-lines%))))

  (element affiliation
    (make display-group
      use: article-titlepage-recto-style
      (process-children)))

  (element artpagenums
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element author
    (let ((author-name  (author-string))
	  (author-affil (select-elements (children (current-node)) 
					 (normalize "affiliation"))))
      (make sequence      
	(make paragraph
          use: article-titlepage-recto-style
	  font-size: (HSIZE 3)
	  line-spacing: (* (HSIZE 3) %line-spacing-factor%)
	  space-before: (* (HSIZE 2) %head-before-factor%)
	  quadding: %article-title-quadding%
	  keep-with-next?: #t
	  (literal author-name))
	(process-node-list author-affil))))

  (element authorblurb
    (make display-group
      use: article-titlepage-recto-style
      quadding: 'start
      (process-children)))

  (element (authorblurb para)
    (make paragraph
      use: article-titlepage-recto-style
      quadding: 'start
      (process-children)))

  (element authorgroup
    (make display-group
      (process-children)))

  (element authorinitials
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element bibliomisc (process-children))

  (element bibliomset (process-children))

  (element collab
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element confgroup
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element contractnum
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element contractsponsor
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element contrib
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element copyright
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      space-before: (* (HSIZE 2) %head-before-factor%)  ;; XXX: OUR HACK
      (literal (gentext-element-name (current-node)))
      (literal "\no-break-space;")
      (literal (dingbat "copyright"))
      (literal "\no-break-space;")
      (process-children)))

  (element (copyright year)
    (make sequence
      (process-children)
      (if (not (last-sibling? (current-node)))
	  (literal ", ")
	  (literal (string-append " " (gentext-by) " ")))))
  
  (element (copyright holder) ($charseq$))

  (element corpauthor
    (make sequence
      (make paragraph
        use: article-titlepage-recto-style
	font-size: (HSIZE 3)
	line-spacing: (* (HSIZE 3) %line-spacing-factor%)
	space-before: (* (HSIZE 2) %head-before-factor%)
	quadding: %article-title-quadding%
	keep-with-next?: #t
	(process-children))
      ;; This paragraph is a hack to get the spacing right.
      ;; Authors always have an affiliation paragraph below them, even if
      ;; it's empty, so corpauthors need one too.
      (make paragraph
        use: article-titlepage-recto-style
	font-size: (HSIZE 1)
	line-spacing: (* (HSIZE 1) %line-spacing-factor%)
	space-after: (* (HSIZE 2) %head-after-factor% 4)
	quadding: %article-title-quadding%
	keep-with-next?: #t
	(literal "\no-break-space;"))))

  (element corpname
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element date
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element edition
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)
      (literal "\no-break-space;")
      (literal (gentext-element-name-space (gi (current-node))))))

  (element editor
    (let ((editor-name (author-string)))
      (make sequence      
	(if (first-sibling?) 
	    (make paragraph
              use: article-titlepage-recto-style
	      font-size: (HSIZE 1)
	      line-spacing: (* (HSIZE 1) %line-spacing-factor%)
	      space-before: (* (HSIZE 2) %head-before-factor% 6)
	      quadding: %article-title-quadding%
	      keep-with-next?: #t
	      (literal (gentext-edited-by)))
	    (empty-sosofo))
	(make paragraph
          use: article-titlepage-recto-style
	  font-size: (HSIZE 3)
	  line-spacing: (* (HSIZE 3) %line-spacing-factor%)
	  space-after: (* (HSIZE 2) %head-after-factor% 4)
	  quadding: %article-title-quadding%
	  keep-with-next?: #t
	  (literal editor-name)))))

  (element firstname
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element graphic
    (let* ((nd (current-node))
	   (fileref (attribute-string "fileref" nd))
	   (entityref (attribute-string "entityref" nd))
	   (format (attribute-string "format" nd))
	   (align (attribute-string "align" nd)))
      (if (or fileref entityref) 
	  (make external-graphic
	    notation-system-id: (if format format "")
	    entity-system-id: (if fileref 
				  (graphic-file fileref)
				  (if entityref 
				      (entity-generated-system-id entityref)
				      ""))
	    display?: #t
	    display-alignment: 'center)
	  (empty-sosofo))))

  (element honorific
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element isbn
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element issn
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element itermset (empty-sosofo))

  (element invpartnumber
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element issuenum
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element jobtitle
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element keywordset
    (make paragraph
      quadding: 'start
      (make sequence
	font-weight: 'bold
	(literal "Keywords: "))
      (process-children)))

  (element keyword
    (make sequence
      (process-children)
      (if (not (last-sibling?))
	  (literal ", ")
	  (literal ""))))

  (element legalnotice
    (make display-group
      use: article-titlepage-recto-style
      ($semiformal-object$)))

  (element (legalnotice title) (empty-sosofo))

  (element (legalnotice para)
    (make paragraph
      use: article-titlepage-recto-style
      quadding: 'start
      line-spacing: (* 0.8 (inherited-line-spacing))
      font-size: (* 0.8 (inherited-font-size))
      (process-children)))

  (element lineage
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element modespec (empty-sosofo))

  (element orgdiv
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element orgname
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element othercredit
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element othername
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element pagenums
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element printhistory
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element productname
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element productnumber
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element pubdate
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element publisher
    (make display-group
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element publishername
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element pubsnumber
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element releaseinfo
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element revhistory
    (make sequence
      (make paragraph
	use: article-titlepage-recto-style
	space-before: (* (HSIZE 3) %head-before-factor%)
	space-after: (/ (* (HSIZE 1) %head-before-factor%) 2)
	(literal (gentext-element-name (current-node))))
      (make table
	before-row-border: #f
	(process-children))))
  
  (element (revhistory revision)
    (let ((revnumber (select-elements (descendants (current-node)) 
				      (normalize "revnumber")))
	  (revdate   (select-elements (descendants (current-node)) 
				      (normalize "date")))
	  (revauthor (select-elements (descendants (current-node))
				      (normalize "authorinitials")))
	  (revremark (select-elements (descendants (current-node))
				      (normalize "revremark"))))
      (make sequence
	(make table-row
	  (make table-cell
	    column-number: 1
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    (if (not (node-list-empty? revnumber))
		(make paragraph
		  use: article-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (literal (gentext-element-name-space (current-node)))
		  (process-node-list revnumber))
		(empty-sosofo)))
	  (make table-cell
	    column-number: 2
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    cell-before-column-margin: (if (equal? (print-backend) 'tex)
					   6pt
					   0pt)
	    (if (not (node-list-empty? revdate))
		(make paragraph
		  use: article-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (process-node-list revdate))
		(empty-sosofo)))
	  (make table-cell
	    column-number: 3
	    n-columns-spanned: 1
	    n-rows-spanned: 1
	    start-indent: 0pt
	    cell-before-column-margin: (if (equal? (print-backend) 'tex)
					   6pt
					   0pt)
	    (if (not (node-list-empty? revauthor))
		(make paragraph
		  use: article-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  (literal (gentext-revised-by))
		  (process-node-list revauthor))
		(empty-sosofo))))
	(make table-row
	  cell-after-row-border: #f
	  (make table-cell
	    column-number: 1
	    n-columns-spanned: 3
	    n-rows-spanned: 1
	    start-indent: 0pt
	    (if (not (node-list-empty? revremark))
		(make paragraph
		  use: article-titlepage-recto-style
		  font-size: %bf-size%
		  font-weight: 'medium
		  space-after: (if (last-sibling?) 
				   0pt
				   (/ %block-sep% 2))
		  (process-node-list revremark))
		(empty-sosofo)))))))
  
  (element (revision revnumber) (process-children-trim))
  (element (revision date) (process-children-trim))
  (element (revision authorinitials) (process-children-trim))
  (element (revision revremark) (process-children-trim))

  (element seriesvolnums
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element shortaffil
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element subjectset (empty-sosofo))

  (element subtitle 
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 4)
      line-spacing: (* (HSIZE 4) %line-spacing-factor%)
      space-before: (* (HSIZE 4) %head-before-factor%)
      quadding: %article-subtitle-quadding%
      keep-with-next?: #t
      (process-children-trim)))

  (element surname
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))

  (element title 
    (make paragraph
      use: article-titlepage-recto-style
      font-size: (HSIZE 5)
      line-spacing: (* (HSIZE 5) %line-spacing-factor%)
      space-before: (* (HSIZE 5) %head-before-factor%)
      quadding: %article-title-quadding%
      keep-with-next?: #t
      (with-mode title-mode
	(process-children-trim))))

  (element titleabbrev (empty-sosofo))

  (element volumenum
    (make paragraph
      use: article-titlepage-recto-style
      quadding: %article-title-quadding%
      (process-children)))
)

</style-specification-body>
</style-specification>


<!--
;; ===================================================
;; customize the html stylesheet; borrowed from Cygnus
;; at http://sourceware.cygnus.com/ (cygnus-both.dsl)
;; ===================================================
-->

<style-specification id="html" use="docbook">
<style-specification-body> 

(declare-characteristic preserve-sdata?
  ;; this is necessary because right now jadetex does not understand
  ;; symbolic entities, whereas things work well with numeric entities.
  "UNREGISTERED::James Clark//Characteristic::preserve-sdata?"
  #f)

(define %generate-legalnotice-link%
  ;; put the legal notice in a separate file
  #t)

(define %admon-graphics-path%
  ;; use graphics in admonitions, set their
  "../images/")

(define %admon-graphics%
  #t)

(define %funcsynopsis-decoration%
  ;; make funcsynopsis look pretty
  #t)

(define %html-ext%
  ;; when producing HTML files, use this extension
  ".html")

(define %generate-book-toc%
  ;; Should a Table of Contents be produced for books?
  #t)

(define %generate-article-toc% 
  ;; Should a Table of Contents be produced for articles?
  #t)

(define %generate-part-toc%
  ;; Should a Table of Contents be produced for parts?
  #t)

(define %generate-book-titlepage%
  ;; produce a title page for books
  #t)

(define %generate-article-titlepage%
  ;; produce a title page for articles
  #t)

(define (chunk-skip-first-element-list)
  ;; forces the Table of Contents on separate page
  '())

(define (list-element-list)
  ;; fixes bug in Table of Contents generation
  '())

(define %root-filename%
  ;; The filename of the root HTML document (e.g, "index").
  "index")

(define %shade-verbatim%
  ;; verbatim sections will be shaded if t(rue)
  #t)

(define %use-id-as-filename%
  ;; Use ID attributes as name for component HTML files?
  #t)

(define %graphic-extensions%
  ;; graphic extensions allowed
  '("gif" "png" "jpg" "jpeg" "tif" "tiff" "eps" "epsf" ))

(define %graphic-default-extension% 
  "gif")

(define %section-autolabel%
  ;; For enumerated sections (1.1, 1.1.1, 1.2, etc.)
  #t)

(define (toc-depth nd)
  ;; more depth (2 levels) to toc; instead of flat hierarchy
  ;; 2)
  4)

(element emphasis
  ;; make role=strong equate to bold for emphasis tag
  (if (equal? (attribute-string "role") "strong")
     (make element gi: "STRONG" (process-children))
     (make element gi: "EM" (process-children))))

(define (book-titlepage-recto-elements)
  ;; elements on a book's titlepage
  ;; note: added revhistory to the default list
  (list (normalize "title")
        (normalize "subtitle")
        (normalize "graphic")
        (normalize "mediaobject")
        (normalize "corpauthor")
        (normalize "authorgroup")
        (normalize "author")
        (normalize "editor")
        (normalize "othercredit")
        (normalize "releaseinfo")
        (normalize "copyright")
        (normalize "revhistory")
        (normalize "abstract")
        (normalize "legalnotice")))

(define (article-titlepage-recto-elements)
  ;; elements on an article's titlepage
  ;; note: added othercredit to the default list
  (list (normalize "title")
        (normalize "subtitle")
        (normalize "authorgroup")
        (normalize "author")
        (normalize "othercredit")
        (normalize "releaseinfo")
        (normalize "copyright")
        (normalize "pubdate")
        (normalize "revhistory")
        (normalize "abstract")))

(mode article-titlepage-recto-mode

 (element contrib
  ;; print out with othercredit information; for translators, etc.
  (make sequence
    (make element gi: "SPAN"
          attributes: (list (list "CLASS" (gi)))
          (process-children))))

 (element othercredit
  ;; print out othercredit information; for translators, etc.
  (let ((author-name  (author-string))
        (author-contrib (select-elements (children (current-node))
                                          (normalize "contrib"))))
    (make element gi: "P"
         attributes: (list (list "CLASS" (gi)))
         (make element gi: "B"  
              (literal author-name)
              (literal " - "))
         (process-node-list author-contrib))))
)

(define (article-title nd)
  (let* ((artchild  (children nd))
         (artheader (select-elements artchild (normalize "artheader")))
         (artinfo   (select-elements artchild (normalize "articleinfo")))
         (ahdr (if (node-list-empty? artheader)
                   artinfo
                   artheader))
         (ahtitles  (select-elements (children ahdr)
                                     (normalize "title")))
         (artitles  (select-elements artchild (normalize "title")))
         (titles    (if (node-list-empty? artitles)
                        ahtitles
                        artitles)))
    (if (node-list-empty? titles)
        ""
        (node-list-first titles))))


;; Redefinition of $verbatim-display$
;; Origin: dbverb.dsl
;; Different foreground and background colors for verbatim elements
;; Author: Philippe Martin (feloy@free.fr) 2001-04-07

(define ($verbatim-display$ indent line-numbers?)
  (let ((verbatim-element (gi))
        (content (make element gi: "PRE"
                       attributes: (list
                                    (list "CLASS" (gi)))
                       (if (or indent line-numbers?)
                           ($verbatim-line-by-line$ indent line-numbers?)
                           (process-children)))))
    (if %shade-verbatim%
        (make element gi: "TABLE"
              attributes: (shade-verbatim-attr-element verbatim-element)
              (make element gi: "TR"
                    (make element gi: "TD"
                          (make element gi: "FONT" 
                                attributes: (list
                                             (list "COLOR" (car (shade-verbatim-element-colors
                                                                 verbatim-element))))
                                content))))
        content)))

;;
;; Customize this function
;; to change the foreground and background colors
;; of the different verbatim elements
;; Return (list "foreground color" "background color")
;;
(define (shade-verbatim-element-colors element)
  (case element
    (("SYNOPSIS") (list "#000000" "#6495ED"))
    ;; ...
    ;; Add your verbatim elements here
    ;; ...
    (else (list "#000000" "#E0E0E0"))))

(define (shade-verbatim-attr-element element)
  (list
   (list "BORDER" 
	(cond
		((equal? element (normalize "SCREEN")) "1")
		(else "0")))
   (list "BGCOLOR" (car (cdr (shade-verbatim-element-colors element))))
   (list "WIDTH" ($table-width$))))

;; End of $verbatim-display$ redefinition

</style-specification-body>
</style-specification>

<external-specification id="docbook" document="docbook.dsl">

</style-sheet>

